# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, constr
from phrasetms_client.models.id_reference import IdReference

class TermBaseEditDto(BaseModel):
    """
    TermBaseEditDto
    """
    name: constr(strict=True, max_length=255, min_length=0) = Field(...)
    langs: conlist(StrictStr, max_items=2147483647, min_items=1) = Field(...)
    client: Optional[IdReference] = None
    domain: Optional[IdReference] = None
    sub_domain: Optional[IdReference] = Field(None, alias="subDomain")
    business_unit: Optional[IdReference] = Field(None, alias="businessUnit")
    owner: Optional[IdReference] = None
    note: Optional[constr(strict=True, max_length=4096, min_length=0)] = None
    __properties = ["name", "langs", "client", "domain", "subDomain", "businessUnit", "owner", "note"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TermBaseEditDto:
        """Create an instance of TermBaseEditDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of client
        if self.client:
            _dict['client'] = self.client.to_dict()
        # override the default output from pydantic by calling `to_dict()` of domain
        if self.domain:
            _dict['domain'] = self.domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sub_domain
        if self.sub_domain:
            _dict['subDomain'] = self.sub_domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of business_unit
        if self.business_unit:
            _dict['businessUnit'] = self.business_unit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TermBaseEditDto:
        """Create an instance of TermBaseEditDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TermBaseEditDto.parse_obj(obj)

        _obj = TermBaseEditDto.parse_obj({
            "name": obj.get("name"),
            "langs": obj.get("langs"),
            "client": IdReference.from_dict(obj.get("client")) if obj.get("client") is not None else None,
            "domain": IdReference.from_dict(obj.get("domain")) if obj.get("domain") is not None else None,
            "sub_domain": IdReference.from_dict(obj.get("subDomain")) if obj.get("subDomain") is not None else None,
            "business_unit": IdReference.from_dict(obj.get("businessUnit")) if obj.get("businessUnit") is not None else None,
            "owner": IdReference.from_dict(obj.get("owner")) if obj.get("owner") is not None else None,
            "note": obj.get("note")
        })
        return _obj

