# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field
from phrasetms_client.models.toggleable_weight_dto import ToggleableWeightDto

class StyleWeightsDto(BaseModel):
    """
    StyleWeightsDto
    """
    style: Optional[ToggleableWeightDto] = None
    awkward: Optional[ToggleableWeightDto] = None
    company_style: Optional[ToggleableWeightDto] = Field(None, alias="companyStyle")
    inconsistent_style: Optional[ToggleableWeightDto] = Field(None, alias="inconsistentStyle")
    third_party_style: Optional[ToggleableWeightDto] = Field(None, alias="thirdPartyStyle")
    unidiomatic: Optional[ToggleableWeightDto] = None
    __properties = ["style", "awkward", "companyStyle", "inconsistentStyle", "thirdPartyStyle", "unidiomatic"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StyleWeightsDto:
        """Create an instance of StyleWeightsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of style
        if self.style:
            _dict['style'] = self.style.to_dict()
        # override the default output from pydantic by calling `to_dict()` of awkward
        if self.awkward:
            _dict['awkward'] = self.awkward.to_dict()
        # override the default output from pydantic by calling `to_dict()` of company_style
        if self.company_style:
            _dict['companyStyle'] = self.company_style.to_dict()
        # override the default output from pydantic by calling `to_dict()` of inconsistent_style
        if self.inconsistent_style:
            _dict['inconsistentStyle'] = self.inconsistent_style.to_dict()
        # override the default output from pydantic by calling `to_dict()` of third_party_style
        if self.third_party_style:
            _dict['thirdPartyStyle'] = self.third_party_style.to_dict()
        # override the default output from pydantic by calling `to_dict()` of unidiomatic
        if self.unidiomatic:
            _dict['unidiomatic'] = self.unidiomatic.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StyleWeightsDto:
        """Create an instance of StyleWeightsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StyleWeightsDto.parse_obj(obj)

        _obj = StyleWeightsDto.parse_obj({
            "style": ToggleableWeightDto.from_dict(obj.get("style")) if obj.get("style") is not None else None,
            "awkward": ToggleableWeightDto.from_dict(obj.get("awkward")) if obj.get("awkward") is not None else None,
            "company_style": ToggleableWeightDto.from_dict(obj.get("companyStyle")) if obj.get("companyStyle") is not None else None,
            "inconsistent_style": ToggleableWeightDto.from_dict(obj.get("inconsistentStyle")) if obj.get("inconsistentStyle") is not None else None,
            "third_party_style": ToggleableWeightDto.from_dict(obj.get("thirdPartyStyle")) if obj.get("thirdPartyStyle") is not None else None,
            "unidiomatic": ToggleableWeightDto.from_dict(obj.get("unidiomatic")) if obj.get("unidiomatic") is not None else None
        })
        return _obj

