# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictInt, confloat, conint
from phrasetms_client.models.uid_reference import UidReference


class SetProjectTransMemoryV3Dto(BaseModel):
    """
    SetProjectTransMemoryV3Dto
    """

    trans_memory: UidReference = Field(..., alias="transMemory")
    read_mode: Optional[StrictBool] = Field(
        None, alias="readMode", description="Default: false"
    )
    write_mode: Optional[StrictBool] = Field(
        None,
        alias="writeMode",
        description="Can be set only for Translation Memory with read == true.<br/>         Max 2 write TMs allowed per project.<br/>         Default: false",
    )
    penalty: Optional[
        Union[confloat(le=100.0, ge=0, strict=True), conint(le=100, ge=0, strict=True)]
    ] = None
    apply_penalty_to101_only: Optional[StrictBool] = Field(
        None,
        alias="applyPenaltyTo101Only",
        description="Can be set only for penalty == 1<br/>Default: false",
    )
    order: Optional[StrictInt] = None
    __properties = [
        "transMemory",
        "readMode",
        "writeMode",
        "penalty",
        "applyPenaltyTo101Only",
        "order",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SetProjectTransMemoryV3Dto:
        """Create an instance of SetProjectTransMemoryV3Dto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of trans_memory
        if self.trans_memory:
            _dict["transMemory"] = self.trans_memory.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SetProjectTransMemoryV3Dto:
        """Create an instance of SetProjectTransMemoryV3Dto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SetProjectTransMemoryV3Dto.parse_obj(obj)

        _obj = SetProjectTransMemoryV3Dto.parse_obj(
            {
                "trans_memory": UidReference.from_dict(obj.get("transMemory"))
                if obj.get("transMemory") is not None
                else None,
                "read_mode": obj.get("readMode"),
                "write_mode": obj.get("writeMode"),
                "penalty": obj.get("penalty"),
                "apply_penalty_to101_only": obj.get("applyPenaltyTo101Only"),
                "order": obj.get("order"),
            }
        )
        return _obj
