# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from phrasetms_client.models.id_reference import IdReference

class SetProjectTemplateTermBaseDto(BaseModel):
    """
    SetProjectTemplateTermBaseDto
    """
    read_term_bases: Optional[conlist(IdReference)] = Field(None, alias="readTermBases")
    write_term_base: Optional[IdReference] = Field(None, alias="writeTermBase")
    quality_assurance_term_bases: Optional[conlist(IdReference)] = Field(None, alias="qualityAssuranceTermBases")
    target_lang: Optional[StrictStr] = Field(None, alias="targetLang")
    workflow_step: Optional[IdReference] = Field(None, alias="workflowStep")
    __properties = ["readTermBases", "writeTermBase", "qualityAssuranceTermBases", "targetLang", "workflowStep"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SetProjectTemplateTermBaseDto:
        """Create an instance of SetProjectTemplateTermBaseDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in read_term_bases (list)
        _items = []
        if self.read_term_bases:
            for _item in self.read_term_bases:
                if _item:
                    _items.append(_item.to_dict())
            _dict['readTermBases'] = _items
        # override the default output from pydantic by calling `to_dict()` of write_term_base
        if self.write_term_base:
            _dict['writeTermBase'] = self.write_term_base.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in quality_assurance_term_bases (list)
        _items = []
        if self.quality_assurance_term_bases:
            for _item in self.quality_assurance_term_bases:
                if _item:
                    _items.append(_item.to_dict())
            _dict['qualityAssuranceTermBases'] = _items
        # override the default output from pydantic by calling `to_dict()` of workflow_step
        if self.workflow_step:
            _dict['workflowStep'] = self.workflow_step.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SetProjectTemplateTermBaseDto:
        """Create an instance of SetProjectTemplateTermBaseDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SetProjectTemplateTermBaseDto.parse_obj(obj)

        _obj = SetProjectTemplateTermBaseDto.parse_obj({
            "read_term_bases": [IdReference.from_dict(_item) for _item in obj.get("readTermBases")] if obj.get("readTermBases") is not None else None,
            "write_term_base": IdReference.from_dict(obj.get("writeTermBase")) if obj.get("writeTermBase") is not None else None,
            "quality_assurance_term_bases": [IdReference.from_dict(_item) for _item in obj.get("qualityAssuranceTermBases")] if obj.get("qualityAssuranceTermBases") is not None else None,
            "target_lang": obj.get("targetLang"),
            "workflow_step": IdReference.from_dict(obj.get("workflowStep")) if obj.get("workflowStep") is not None else None
        })
        return _obj

