# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from phrasetms_client.models.auth_schema import AuthSchema
from phrasetms_client.models.supported import Supported

class ServiceProviderConfigDto(BaseModel):
    """
    ServiceProviderConfigDto
    """
    authentication_schemes: Optional[conlist(AuthSchema)] = Field(None, alias="authenticationSchemes")
    schemas: Optional[conlist(StrictStr)] = None
    patch: Optional[Supported] = None
    bulk: Optional[Supported] = None
    filter: Optional[Supported] = None
    change_password: Optional[Supported] = Field(None, alias="changePassword")
    sort: Optional[Supported] = None
    etag: Optional[Supported] = None
    xml_data_format: Optional[Supported] = Field(None, alias="xmlDataFormat")
    __properties = ["authenticationSchemes", "schemas", "patch", "bulk", "filter", "changePassword", "sort", "etag", "xmlDataFormat"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ServiceProviderConfigDto:
        """Create an instance of ServiceProviderConfigDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in authentication_schemes (list)
        _items = []
        if self.authentication_schemes:
            for _item in self.authentication_schemes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['authenticationSchemes'] = _items
        # override the default output from pydantic by calling `to_dict()` of patch
        if self.patch:
            _dict['patch'] = self.patch.to_dict()
        # override the default output from pydantic by calling `to_dict()` of bulk
        if self.bulk:
            _dict['bulk'] = self.bulk.to_dict()
        # override the default output from pydantic by calling `to_dict()` of filter
        if self.filter:
            _dict['filter'] = self.filter.to_dict()
        # override the default output from pydantic by calling `to_dict()` of change_password
        if self.change_password:
            _dict['changePassword'] = self.change_password.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sort
        if self.sort:
            _dict['sort'] = self.sort.to_dict()
        # override the default output from pydantic by calling `to_dict()` of etag
        if self.etag:
            _dict['etag'] = self.etag.to_dict()
        # override the default output from pydantic by calling `to_dict()` of xml_data_format
        if self.xml_data_format:
            _dict['xmlDataFormat'] = self.xml_data_format.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceProviderConfigDto:
        """Create an instance of ServiceProviderConfigDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ServiceProviderConfigDto.parse_obj(obj)

        _obj = ServiceProviderConfigDto.parse_obj({
            "authentication_schemes": [AuthSchema.from_dict(_item) for _item in obj.get("authenticationSchemes")] if obj.get("authenticationSchemes") is not None else None,
            "schemas": obj.get("schemas"),
            "patch": Supported.from_dict(obj.get("patch")) if obj.get("patch") is not None else None,
            "bulk": Supported.from_dict(obj.get("bulk")) if obj.get("bulk") is not None else None,
            "filter": Supported.from_dict(obj.get("filter")) if obj.get("filter") is not None else None,
            "change_password": Supported.from_dict(obj.get("changePassword")) if obj.get("changePassword") is not None else None,
            "sort": Supported.from_dict(obj.get("sort")) if obj.get("sort") is not None else None,
            "etag": Supported.from_dict(obj.get("etag")) if obj.get("etag") is not None else None,
            "xml_data_format": Supported.from_dict(obj.get("xmlDataFormat")) if obj.get("xmlDataFormat") is not None else None
        })
        return _obj

