# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel
from phrasetms_client.models.comment_dto import CommentDto
from phrasetms_client.models.common_conversation_dto import CommonConversationDto
from phrasetms_client.models.mentionable_user_dto import MentionableUserDto
from phrasetms_client.models.plain_references import PlainReferences
from phrasetms_client.models.status_dto import StatusDto

class SEGMENTTARGET(CommonConversationDto):
    """
    SEGMENTTARGET
    """
    references: Optional[PlainReferences] = None
    __properties = ["id", "type", "dateCreated", "dateModified", "dateEdited", "createdBy", "comments", "status", "deleted", "references"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SEGMENTTARGET:
        """Create an instance of SEGMENTTARGET from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in comments (list)
        _items = []
        if self.comments:
            for _item in self.comments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['comments'] = _items
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of references
        if self.references:
            _dict['references'] = self.references.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SEGMENTTARGET:
        """Create an instance of SEGMENTTARGET from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SEGMENTTARGET.parse_obj(obj)

        _obj = SEGMENTTARGET.parse_obj({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "date_created": obj.get("dateCreated"),
            "date_modified": obj.get("dateModified"),
            "date_edited": obj.get("dateEdited"),
            "created_by": MentionableUserDto.from_dict(obj.get("createdBy")) if obj.get("createdBy") is not None else None,
            "comments": [CommentDto.from_dict(_item) for _item in obj.get("comments")] if obj.get("comments") is not None else None,
            "status": StatusDto.from_dict(obj.get("status")) if obj.get("status") is not None else None,
            "deleted": obj.get("deleted"),
            "references": PlainReferences.from_dict(obj.get("references")) if obj.get("references") is not None else None
        })
        return _obj

