# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from phrasetms_client.models.previous_workflow_dto import PreviousWorkflowDto
from phrasetms_client.models.segments_counts_dto import SegmentsCountsDto

class SegmentsCountsResponseDto(BaseModel):
    """
    SegmentsCountsResponseDto
    """
    job_part_uid: Optional[StrictStr] = Field(None, alias="jobPartUid")
    counts: Optional[SegmentsCountsDto] = None
    previous_workflow: Optional[PreviousWorkflowDto] = Field(None, alias="previousWorkflow")
    __properties = ["jobPartUid", "counts", "previousWorkflow"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SegmentsCountsResponseDto:
        """Create an instance of SegmentsCountsResponseDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of counts
        if self.counts:
            _dict['counts'] = self.counts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of previous_workflow
        if self.previous_workflow:
            _dict['previousWorkflow'] = self.previous_workflow.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SegmentsCountsResponseDto:
        """Create an instance of SegmentsCountsResponseDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SegmentsCountsResponseDto.parse_obj(obj)

        _obj = SegmentsCountsResponseDto.parse_obj({
            "job_part_uid": obj.get("jobPartUid"),
            "counts": SegmentsCountsDto.from_dict(obj.get("counts")) if obj.get("counts") is not None else None,
            "previous_workflow": PreviousWorkflowDto.from_dict(obj.get("previousWorkflow")) if obj.get("previousWorkflow") is not None else None
        })
        return _obj

