# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt
from phrasetms_client.models.quality_assurance_dto import QualityAssuranceDto

class SegmentsCountsDto(BaseModel):
    """
    SegmentsCountsDto
    """
    all_confirmed: Optional[StrictBool] = Field(None, alias="allConfirmed")
    chars_count: Optional[StrictInt] = Field(None, alias="charsCount")
    completed_chars_count: Optional[StrictInt] = Field(None, alias="completedCharsCount")
    confirmed_chars_count: Optional[StrictInt] = Field(None, alias="confirmedCharsCount")
    confirmed_locked_chars_count: Optional[StrictInt] = Field(None, alias="confirmedLockedCharsCount")
    locked_chars_count: Optional[StrictInt] = Field(None, alias="lockedCharsCount")
    segments_count: Optional[StrictInt] = Field(None, alias="segmentsCount")
    completed_segments_count: Optional[StrictInt] = Field(None, alias="completedSegmentsCount")
    locked_segments_count: Optional[StrictInt] = Field(None, alias="lockedSegmentsCount")
    segment_groups_count: Optional[StrictInt] = Field(None, alias="segmentGroupsCount")
    translated_segments_count: Optional[StrictInt] = Field(None, alias="translatedSegmentsCount")
    translated_locked_segments_count: Optional[StrictInt] = Field(None, alias="translatedLockedSegmentsCount")
    words_count: Optional[StrictInt] = Field(None, alias="wordsCount")
    completed_words_count: Optional[StrictInt] = Field(None, alias="completedWordsCount")
    confirmed_words_count: Optional[StrictInt] = Field(None, alias="confirmedWordsCount")
    confirmed_locked_words_count: Optional[StrictInt] = Field(None, alias="confirmedLockedWordsCount")
    locked_words_count: Optional[StrictInt] = Field(None, alias="lockedWordsCount")
    added_segments: Optional[StrictInt] = Field(None, alias="addedSegments")
    added_words: Optional[StrictInt] = Field(None, alias="addedWords")
    machine_translation_post_edited_segments_count: Optional[StrictInt] = Field(None, alias="machineTranslationPostEditedSegmentsCount")
    machine_translation_relevant_segments_count: Optional[StrictInt] = Field(None, alias="machineTranslationRelevantSegmentsCount")
    quality_assurance: Optional[QualityAssuranceDto] = Field(None, alias="qualityAssurance")
    quality_assurance_resolved: Optional[StrictBool] = Field(None, alias="qualityAssuranceResolved")
    __properties = ["allConfirmed", "charsCount", "completedCharsCount", "confirmedCharsCount", "confirmedLockedCharsCount", "lockedCharsCount", "segmentsCount", "completedSegmentsCount", "lockedSegmentsCount", "segmentGroupsCount", "translatedSegmentsCount", "translatedLockedSegmentsCount", "wordsCount", "completedWordsCount", "confirmedWordsCount", "confirmedLockedWordsCount", "lockedWordsCount", "addedSegments", "addedWords", "machineTranslationPostEditedSegmentsCount", "machineTranslationRelevantSegmentsCount", "qualityAssurance", "qualityAssuranceResolved"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SegmentsCountsDto:
        """Create an instance of SegmentsCountsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of quality_assurance
        if self.quality_assurance:
            _dict['qualityAssurance'] = self.quality_assurance.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SegmentsCountsDto:
        """Create an instance of SegmentsCountsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SegmentsCountsDto.parse_obj(obj)

        _obj = SegmentsCountsDto.parse_obj({
            "all_confirmed": obj.get("allConfirmed"),
            "chars_count": obj.get("charsCount"),
            "completed_chars_count": obj.get("completedCharsCount"),
            "confirmed_chars_count": obj.get("confirmedCharsCount"),
            "confirmed_locked_chars_count": obj.get("confirmedLockedCharsCount"),
            "locked_chars_count": obj.get("lockedCharsCount"),
            "segments_count": obj.get("segmentsCount"),
            "completed_segments_count": obj.get("completedSegmentsCount"),
            "locked_segments_count": obj.get("lockedSegmentsCount"),
            "segment_groups_count": obj.get("segmentGroupsCount"),
            "translated_segments_count": obj.get("translatedSegmentsCount"),
            "translated_locked_segments_count": obj.get("translatedLockedSegmentsCount"),
            "words_count": obj.get("wordsCount"),
            "completed_words_count": obj.get("completedWordsCount"),
            "confirmed_words_count": obj.get("confirmedWordsCount"),
            "confirmed_locked_words_count": obj.get("confirmedLockedWordsCount"),
            "locked_words_count": obj.get("lockedWordsCount"),
            "added_segments": obj.get("addedSegments"),
            "added_words": obj.get("addedWords"),
            "machine_translation_post_edited_segments_count": obj.get("machineTranslationPostEditedSegmentsCount"),
            "machine_translation_relevant_segments_count": obj.get("machineTranslationRelevantSegmentsCount"),
            "quality_assurance": QualityAssuranceDto.from_dict(obj.get("qualityAssurance")) if obj.get("qualityAssurance") is not None else None,
            "quality_assurance_resolved": obj.get("qualityAssuranceResolved")
        })
        return _obj

