# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictStr, confloat, conint, conlist
from phrasetms_client.models.tag_metadata_dto import TagMetadataDto

class SearchTMByJobRequestDto(BaseModel):
    """
    SearchTMByJobRequestDto
    """
    segment: StrictStr = Field(...)
    workflow_level: Optional[conint(strict=True, le=15, ge=1)] = Field(None, alias="workflowLevel")
    score_threshold: Optional[Union[confloat(le=1.01, ge=0, strict=True), conint(le=1, ge=0, strict=True)]] = Field(None, alias="scoreThreshold")
    previous_segment: Optional[StrictStr] = Field(None, alias="previousSegment")
    next_segment: Optional[StrictStr] = Field(None, alias="nextSegment")
    context_key: Optional[StrictStr] = Field(None, alias="contextKey")
    max_segments: Optional[conint(strict=True, le=5, ge=0)] = Field(None, alias="maxSegments", description="Default: 5")
    max_sub_segments: Optional[conint(strict=True, le=5, ge=0)] = Field(None, alias="maxSubSegments", description="Default: 5")
    tag_metadata: Optional[conlist(TagMetadataDto)] = Field(None, alias="tagMetadata")
    __properties = ["segment", "workflowLevel", "scoreThreshold", "previousSegment", "nextSegment", "contextKey", "maxSegments", "maxSubSegments", "tagMetadata"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SearchTMByJobRequestDto:
        """Create an instance of SearchTMByJobRequestDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in tag_metadata (list)
        _items = []
        if self.tag_metadata:
            for _item in self.tag_metadata:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tagMetadata'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SearchTMByJobRequestDto:
        """Create an instance of SearchTMByJobRequestDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SearchTMByJobRequestDto.parse_obj(obj)

        _obj = SearchTMByJobRequestDto.parse_obj({
            "segment": obj.get("segment"),
            "workflow_level": obj.get("workflowLevel"),
            "score_threshold": obj.get("scoreThreshold"),
            "previous_segment": obj.get("previousSegment"),
            "next_segment": obj.get("nextSegment"),
            "context_key": obj.get("contextKey"),
            "max_segments": obj.get("maxSegments"),
            "max_sub_segments": obj.get("maxSubSegments"),
            "tag_metadata": [TagMetadataDto.from_dict(_item) for _item in obj.get("tagMetadata")] if obj.get("tagMetadata") is not None else None
        })
        return _obj

