# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from phrasetms_client.models.search_tm_client_dto import SearchTMClientDto
from phrasetms_client.models.search_tm_domain_dto import SearchTMDomainDto
from phrasetms_client.models.search_tm_project_dto import SearchTMProjectDto
from phrasetms_client.models.search_tm_sub_domain_dto import SearchTMSubDomainDto
from phrasetms_client.models.tag_metadata import TagMetadata
from phrasetms_client.models.user_reference import UserReference

class SearchTMSegmentDto(BaseModel):
    """
    SearchTMSegmentDto
    """
    id: Optional[StrictStr] = None
    text: Optional[StrictStr] = None
    lang: Optional[StrictStr] = None
    rtl: Optional[StrictBool] = None
    modified_at: Optional[StrictInt] = Field(None, alias="modifiedAt")
    created_at: Optional[StrictInt] = Field(None, alias="createdAt")
    modified_by: Optional[UserReference] = Field(None, alias="modifiedBy")
    created_by: Optional[UserReference] = Field(None, alias="createdBy")
    filename: Optional[StrictStr] = None
    project: Optional[SearchTMProjectDto] = None
    client: Optional[SearchTMClientDto] = None
    domain: Optional[SearchTMDomainDto] = None
    sub_domain: Optional[SearchTMSubDomainDto] = Field(None, alias="subDomain")
    tag_metadata: Optional[conlist(TagMetadata)] = Field(None, alias="tagMetadata")
    previous_segment: Optional[StrictStr] = Field(None, alias="previousSegment")
    next_segment: Optional[StrictStr] = Field(None, alias="nextSegment")
    key: Optional[StrictStr] = None
    __properties = ["id", "text", "lang", "rtl", "modifiedAt", "createdAt", "modifiedBy", "createdBy", "filename", "project", "client", "domain", "subDomain", "tagMetadata", "previousSegment", "nextSegment", "key"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SearchTMSegmentDto:
        """Create an instance of SearchTMSegmentDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of modified_by
        if self.modified_by:
            _dict['modifiedBy'] = self.modified_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of client
        if self.client:
            _dict['client'] = self.client.to_dict()
        # override the default output from pydantic by calling `to_dict()` of domain
        if self.domain:
            _dict['domain'] = self.domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sub_domain
        if self.sub_domain:
            _dict['subDomain'] = self.sub_domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tag_metadata (list)
        _items = []
        if self.tag_metadata:
            for _item in self.tag_metadata:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tagMetadata'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SearchTMSegmentDto:
        """Create an instance of SearchTMSegmentDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SearchTMSegmentDto.parse_obj(obj)

        _obj = SearchTMSegmentDto.parse_obj({
            "id": obj.get("id"),
            "text": obj.get("text"),
            "lang": obj.get("lang"),
            "rtl": obj.get("rtl"),
            "modified_at": obj.get("modifiedAt"),
            "created_at": obj.get("createdAt"),
            "modified_by": UserReference.from_dict(obj.get("modifiedBy")) if obj.get("modifiedBy") is not None else None,
            "created_by": UserReference.from_dict(obj.get("createdBy")) if obj.get("createdBy") is not None else None,
            "filename": obj.get("filename"),
            "project": SearchTMProjectDto.from_dict(obj.get("project")) if obj.get("project") is not None else None,
            "client": SearchTMClientDto.from_dict(obj.get("client")) if obj.get("client") is not None else None,
            "domain": SearchTMDomainDto.from_dict(obj.get("domain")) if obj.get("domain") is not None else None,
            "sub_domain": SearchTMSubDomainDto.from_dict(obj.get("subDomain")) if obj.get("subDomain") is not None else None,
            "tag_metadata": [TagMetadata.from_dict(_item) for _item in obj.get("tagMetadata")] if obj.get("tagMetadata") is not None else None,
            "previous_segment": obj.get("previousSegment"),
            "next_segment": obj.get("nextSegment"),
            "key": obj.get("key")
        })
        return _obj

