# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, conlist
from phrasetms_client.models.search_tm_segment_dto_v3 import SearchTMSegmentDtoV3
from phrasetms_client.models.search_tm_trans_memory_dto_v3 import SearchTMTransMemoryDtoV3

class SearchTMResponseDtoV3(BaseModel):
    """
    SearchTMResponseDtoV3
    """
    segment_id: Optional[StrictStr] = Field(None, alias="segmentId")
    source: Optional[SearchTMSegmentDtoV3] = None
    translations: Optional[conlist(SearchTMSegmentDtoV3)] = None
    trans_memory: Optional[SearchTMTransMemoryDtoV3] = Field(None, alias="transMemory")
    gross_score: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="grossScore")
    score: Optional[Union[StrictFloat, StrictInt]] = None
    sub_segment: Optional[StrictBool] = Field(None, alias="subSegment")
    __properties = ["segmentId", "source", "translations", "transMemory", "grossScore", "score", "subSegment"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SearchTMResponseDtoV3:
        """Create an instance of SearchTMResponseDtoV3 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of source
        if self.source:
            _dict['source'] = self.source.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in translations (list)
        _items = []
        if self.translations:
            for _item in self.translations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['translations'] = _items
        # override the default output from pydantic by calling `to_dict()` of trans_memory
        if self.trans_memory:
            _dict['transMemory'] = self.trans_memory.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SearchTMResponseDtoV3:
        """Create an instance of SearchTMResponseDtoV3 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SearchTMResponseDtoV3.parse_obj(obj)

        _obj = SearchTMResponseDtoV3.parse_obj({
            "segment_id": obj.get("segmentId"),
            "source": SearchTMSegmentDtoV3.from_dict(obj.get("source")) if obj.get("source") is not None else None,
            "translations": [SearchTMSegmentDtoV3.from_dict(_item) for _item in obj.get("translations")] if obj.get("translations") is not None else None,
            "trans_memory": SearchTMTransMemoryDtoV3.from_dict(obj.get("transMemory")) if obj.get("transMemory") is not None else None,
            "gross_score": obj.get("grossScore"),
            "score": obj.get("score"),
            "sub_segment": obj.get("subSegment")
        })
        return _obj

