# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, conlist
from phrasetms_client.models.concept_dtov2 import ConceptDtov2
from phrasetms_client.models.match import Match
from phrasetms_client.models.term_base_reference import TermBaseReference
from phrasetms_client.models.term_v2_dto import TermV2Dto

class SearchInTextResponse2Dto(BaseModel):
    """
    SearchInTextResponse2Dto
    """
    term_base: Optional[TermBaseReference] = Field(None, alias="termBase")
    source_term: Optional[TermV2Dto] = Field(None, alias="sourceTerm")
    concept: Optional[ConceptDtov2] = None
    translation_terms: Optional[conlist(TermV2Dto)] = Field(None, alias="translationTerms")
    sub_term: Optional[StrictBool] = Field(None, alias="subTerm")
    matches: Optional[conlist(Match)] = None
    __properties = ["termBase", "sourceTerm", "concept", "translationTerms", "subTerm", "matches"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SearchInTextResponse2Dto:
        """Create an instance of SearchInTextResponse2Dto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of term_base
        if self.term_base:
            _dict['termBase'] = self.term_base.to_dict()
        # override the default output from pydantic by calling `to_dict()` of source_term
        if self.source_term:
            _dict['sourceTerm'] = self.source_term.to_dict()
        # override the default output from pydantic by calling `to_dict()` of concept
        if self.concept:
            _dict['concept'] = self.concept.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in translation_terms (list)
        _items = []
        if self.translation_terms:
            for _item in self.translation_terms:
                if _item:
                    _items.append(_item.to_dict())
            _dict['translationTerms'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in matches (list)
        _items = []
        if self.matches:
            for _item in self.matches:
                if _item:
                    _items.append(_item.to_dict())
            _dict['matches'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SearchInTextResponse2Dto:
        """Create an instance of SearchInTextResponse2Dto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SearchInTextResponse2Dto.parse_obj(obj)

        _obj = SearchInTextResponse2Dto.parse_obj({
            "term_base": TermBaseReference.from_dict(obj.get("termBase")) if obj.get("termBase") is not None else None,
            "source_term": TermV2Dto.from_dict(obj.get("sourceTerm")) if obj.get("sourceTerm") is not None else None,
            "concept": ConceptDtov2.from_dict(obj.get("concept")) if obj.get("concept") is not None else None,
            "translation_terms": [TermV2Dto.from_dict(_item) for _item in obj.get("translationTerms")] if obj.get("translationTerms") is not None else None,
            "sub_term": obj.get("subTerm"),
            "matches": [Match.from_dict(_item) for _item in obj.get("matches")] if obj.get("matches") is not None else None
        })
        return _obj

