# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from phrasetms_client.models.email import Email
from phrasetms_client.models.name import Name
from phrasetms_client.models.scim_meta import ScimMeta

class ScimUserCoreDto(BaseModel):
    """
    ScimUserCoreDto
    """
    id: Optional[StrictStr] = None
    user_name: StrictStr = Field(..., alias="userName")
    name: Name = Field(...)
    active: Optional[StrictBool] = Field(None, description="Default: true")
    emails: conlist(Email, max_items=2147483647, min_items=1) = Field(...)
    meta: Optional[ScimMeta] = None
    __properties = ["id", "userName", "name", "active", "emails", "meta"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ScimUserCoreDto:
        """Create an instance of ScimUserCoreDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "id",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of name
        if self.name:
            _dict['name'] = self.name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in emails (list)
        _items = []
        if self.emails:
            for _item in self.emails:
                if _item:
                    _items.append(_item.to_dict())
            _dict['emails'] = _items
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ScimUserCoreDto:
        """Create an instance of ScimUserCoreDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ScimUserCoreDto.parse_obj(obj)

        _obj = ScimUserCoreDto.parse_obj({
            "id": obj.get("id"),
            "user_name": obj.get("userName"),
            "name": Name.from_dict(obj.get("name")) if obj.get("name") is not None else None,
            "active": obj.get("active"),
            "emails": [Email.from_dict(_item) for _item in obj.get("emails")] if obj.get("emails") is not None else None,
            "meta": ScimMeta.from_dict(obj.get("meta")) if obj.get("meta") is not None else None
        })
        return _obj

