# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, conlist, validator
from phrasetms_client.models.net_rate_scheme_reference import NetRateSchemeReference
from phrasetms_client.models.price_list_reference import PriceListReference
from phrasetms_client.models.provider_reference import ProviderReference
from phrasetms_client.models.user_reference import UserReference
from phrasetms_client.models.workflow_step_reference import WorkflowStepReference

class QuoteDto(BaseModel):
    """
    QuoteDto
    """
    id: Optional[StrictInt] = None
    uid: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    currency: Optional[StrictStr] = None
    billing_unit: Optional[StrictStr] = Field(None, alias="billingUnit")
    created_by: Optional[UserReference] = Field(None, alias="createdBy")
    date_created: Optional[datetime] = Field(None, alias="dateCreated")
    total_price: Optional[Union[StrictFloat, StrictInt]] = Field(None, alias="totalPrice")
    net_rate_scheme: Optional[NetRateSchemeReference] = Field(None, alias="netRateScheme")
    price_list: Optional[PriceListReference] = Field(None, alias="priceList")
    workflow_step_list: Optional[conlist(WorkflowStepReference)] = Field(None, alias="workflowStepList")
    provider: Optional[ProviderReference] = None
    customer_email: Optional[StrictStr] = Field(None, alias="customerEmail")
    quote_type: Optional[StrictStr] = Field(None, alias="quoteType")
    editable: Optional[StrictBool] = None
    outdated: Optional[StrictBool] = None
    __properties = ["id", "uid", "name", "status", "currency", "billingUnit", "createdBy", "dateCreated", "totalPrice", "netRateScheme", "priceList", "workflowStepList", "provider", "customerEmail", "quoteType", "editable", "outdated"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('APPROVED', 'DECLINED', 'DRAFT', 'FOR_APPROVAL', 'NEW'):
            raise ValueError("must be one of enum values ('APPROVED', 'DECLINED', 'DRAFT', 'FOR_APPROVAL', 'NEW')")
        return value

    @validator('billing_unit')
    def billing_unit_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Character', 'Word', 'Page', 'Hour'):
            raise ValueError("must be one of enum values ('Character', 'Word', 'Page', 'Hour')")
        return value

    @validator('quote_type')
    def quote_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('BUYER', 'PROVIDER'):
            raise ValueError("must be one of enum values ('BUYER', 'PROVIDER')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> QuoteDto:
        """Create an instance of QuoteDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of net_rate_scheme
        if self.net_rate_scheme:
            _dict['netRateScheme'] = self.net_rate_scheme.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price_list
        if self.price_list:
            _dict['priceList'] = self.price_list.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in workflow_step_list (list)
        _items = []
        if self.workflow_step_list:
            for _item in self.workflow_step_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict['workflowStepList'] = _items
        # override the default output from pydantic by calling `to_dict()` of provider
        if self.provider:
            _dict['provider'] = self.provider.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> QuoteDto:
        """Create an instance of QuoteDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return QuoteDto.parse_obj(obj)

        _obj = QuoteDto.parse_obj({
            "id": obj.get("id"),
            "uid": obj.get("uid"),
            "name": obj.get("name"),
            "status": obj.get("status"),
            "currency": obj.get("currency"),
            "billing_unit": obj.get("billingUnit"),
            "created_by": UserReference.from_dict(obj.get("createdBy")) if obj.get("createdBy") is not None else None,
            "date_created": obj.get("dateCreated"),
            "total_price": obj.get("totalPrice"),
            "net_rate_scheme": NetRateSchemeReference.from_dict(obj.get("netRateScheme")) if obj.get("netRateScheme") is not None else None,
            "price_list": PriceListReference.from_dict(obj.get("priceList")) if obj.get("priceList") is not None else None,
            "workflow_step_list": [WorkflowStepReference.from_dict(_item) for _item in obj.get("workflowStepList")] if obj.get("workflowStepList") is not None else None,
            "provider": ProviderReference.from_dict(obj.get("provider")) if obj.get("provider") is not None else None,
            "customer_email": obj.get("customerEmail"),
            "quote_type": obj.get("quoteType"),
            "editable": obj.get("editable"),
            "outdated": obj.get("outdated")
        })
        return _obj

