# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, constr
from phrasetms_client.models.id_reference import IdReference
from phrasetms_client.models.provider_reference import ProviderReference
from phrasetms_client.models.quote_units_dto import QuoteUnitsDto
from phrasetms_client.models.quote_workflow_setting_dto import QuoteWorkflowSettingDto
from phrasetms_client.models.uid_reference import UidReference

class QuoteCreateV2Dto(BaseModel):
    """
    QuoteCreateV2Dto
    """
    name: constr(strict=True, max_length=255, min_length=0) = Field(...)
    project: UidReference = Field(...)
    analyse: IdReference = Field(...)
    price_list: IdReference = Field(..., alias="priceList")
    net_rate_scheme: Optional[IdReference] = Field(None, alias="netRateScheme")
    provider: Optional[ProviderReference] = None
    workflow_settings: Optional[conlist(QuoteWorkflowSettingDto, unique_items=True)] = Field(None, alias="workflowSettings")
    units: Optional[conlist(QuoteUnitsDto)] = None
    additional_steps: Optional[conlist(StrictStr)] = Field(None, alias="additionalSteps")
    __properties = ["name", "project", "analyse", "priceList", "netRateScheme", "provider", "workflowSettings", "units", "additionalSteps"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> QuoteCreateV2Dto:
        """Create an instance of QuoteCreateV2Dto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of analyse
        if self.analyse:
            _dict['analyse'] = self.analyse.to_dict()
        # override the default output from pydantic by calling `to_dict()` of price_list
        if self.price_list:
            _dict['priceList'] = self.price_list.to_dict()
        # override the default output from pydantic by calling `to_dict()` of net_rate_scheme
        if self.net_rate_scheme:
            _dict['netRateScheme'] = self.net_rate_scheme.to_dict()
        # override the default output from pydantic by calling `to_dict()` of provider
        if self.provider:
            _dict['provider'] = self.provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in workflow_settings (list)
        _items = []
        if self.workflow_settings:
            for _item in self.workflow_settings:
                if _item:
                    _items.append(_item.to_dict())
            _dict['workflowSettings'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in units (list)
        _items = []
        if self.units:
            for _item in self.units:
                if _item:
                    _items.append(_item.to_dict())
            _dict['units'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> QuoteCreateV2Dto:
        """Create an instance of QuoteCreateV2Dto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return QuoteCreateV2Dto.parse_obj(obj)

        _obj = QuoteCreateV2Dto.parse_obj({
            "name": obj.get("name"),
            "project": UidReference.from_dict(obj.get("project")) if obj.get("project") is not None else None,
            "analyse": IdReference.from_dict(obj.get("analyse")) if obj.get("analyse") is not None else None,
            "price_list": IdReference.from_dict(obj.get("priceList")) if obj.get("priceList") is not None else None,
            "net_rate_scheme": IdReference.from_dict(obj.get("netRateScheme")) if obj.get("netRateScheme") is not None else None,
            "provider": ProviderReference.from_dict(obj.get("provider")) if obj.get("provider") is not None else None,
            "workflow_settings": [QuoteWorkflowSettingDto.from_dict(_item) for _item in obj.get("workflowSettings")] if obj.get("workflowSettings") is not None else None,
            "units": [QuoteUnitsDto.from_dict(_item) for _item in obj.get("units")] if obj.get("units") is not None else None,
            "additional_steps": obj.get("additionalSteps")
        })
        return _obj

