# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conint, conlist, validator
from phrasetms_client.models.segment_reference import SegmentReference

class QualityAssuranceRunDtoV3(BaseModel):
    """
    QualityAssuranceRunDtoV3
    """
    initial_segment: Optional[SegmentReference] = Field(None, alias="initialSegment")
    max_qa_warnings_count: Optional[conint(strict=True, le=1000, ge=1)] = Field(None, alias="maxQaWarningsCount", description="Maximum number of QA warnings in result, default: 100. For efficiency reasons QA warnings are processed with minimum segments chunk size 10, therefore slightly more warnings are returned.")
    warning_types: Optional[conlist(StrictStr, max_items=100, min_items=0)] = Field(None, alias="warningTypes")
    __properties = ["initialSegment", "maxQaWarningsCount", "warningTypes"]

    @validator('warning_types')
    def warning_types_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in ('EmptyTranslation', 'TrailingPunctuation', 'Formatting', 'JoinTags', 'MissingNumbersV3', 'MultipleSpacesV3', 'NonConformingTerm', 'NotConfirmed', 'TranslationLength', 'AbsoluteLength', 'RelativeLength', 'UnresolvedComment', 'EmptyPairTags', 'InconsistentTranslationTargetSource', 'InconsistentTranslationSourceTarget', 'ForbiddenString', 'SpellCheck', 'RepeatedWord', 'InconsistentTagContent', 'EmptyTagContent', 'Malformed', 'ForbiddenTerm', 'NewerAtLowerLevel', 'LeadingAndTrailingSpaces', 'LeadingSpaces', 'TrailingSpaces', 'TargetSourceIdentical', 'SourceOrTargetRegexp', 'UnmodifiedFuzzyTranslation', 'UnmodifiedFuzzyTranslationTM', 'UnmodifiedFuzzyTranslationMTNT', 'Moravia', 'ExtraNumbersV3', 'UnresolvedConversation', 'NestedTags', 'FuzzyInconsistencyTargetSource', 'FuzzyInconsistencySourceTarget', 'CustomQA'):
                raise ValueError("each list item must be one of ('EmptyTranslation', 'TrailingPunctuation', 'Formatting', 'JoinTags', 'MissingNumbersV3', 'MultipleSpacesV3', 'NonConformingTerm', 'NotConfirmed', 'TranslationLength', 'AbsoluteLength', 'RelativeLength', 'UnresolvedComment', 'EmptyPairTags', 'InconsistentTranslationTargetSource', 'InconsistentTranslationSourceTarget', 'ForbiddenString', 'SpellCheck', 'RepeatedWord', 'InconsistentTagContent', 'EmptyTagContent', 'Malformed', 'ForbiddenTerm', 'NewerAtLowerLevel', 'LeadingAndTrailingSpaces', 'LeadingSpaces', 'TrailingSpaces', 'TargetSourceIdentical', 'SourceOrTargetRegexp', 'UnmodifiedFuzzyTranslation', 'UnmodifiedFuzzyTranslationTM', 'UnmodifiedFuzzyTranslationMTNT', 'Moravia', 'ExtraNumbersV3', 'UnresolvedConversation', 'NestedTags', 'FuzzyInconsistencyTargetSource', 'FuzzyInconsistencySourceTarget', 'CustomQA')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> QualityAssuranceRunDtoV3:
        """Create an instance of QualityAssuranceRunDtoV3 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of initial_segment
        if self.initial_segment:
            _dict['initialSegment'] = self.initial_segment.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> QualityAssuranceRunDtoV3:
        """Create an instance of QualityAssuranceRunDtoV3 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return QualityAssuranceRunDtoV3.parse_obj(obj)

        _obj = QualityAssuranceRunDtoV3.parse_obj({
            "initial_segment": SegmentReference.from_dict(obj.get("initialSegment")) if obj.get("initialSegment") is not None else None,
            "max_qa_warnings_count": obj.get("maxQaWarningsCount"),
            "warning_types": obj.get("warningTypes")
        })
        return _obj

