# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from phrasetms_client.models.enabled_check_dto_v2 import EnabledCheckDtoV2
from phrasetms_client.models.regexp_check_rule_dto_v2 import RegexpCheckRuleDtoV2

class QualityAssuranceChecksDtoV2(BaseModel):
    """
    QualityAssuranceChecksDtoV2
    """
    forbidden_strings: Optional[conlist(StrictStr)] = Field(None, alias="forbiddenStrings")
    enabled_checks: Optional[conlist(EnabledCheckDtoV2)] = Field(None, alias="enabledChecks", description="enabledChecks")
    exclude_locked_segments: Optional[StrictBool] = Field(None, alias="excludeLockedSegments")
    user_can_set_instant_qa: Optional[StrictBool] = Field(None, alias="userCanSetInstantQA")
    strict_job_status: Optional[StrictBool] = Field(None, alias="strictJobStatus")
    regexp_rules: Optional[conlist(RegexpCheckRuleDtoV2)] = Field(None, alias="regexpRules")
    __properties = ["forbiddenStrings", "enabledChecks", "excludeLockedSegments", "userCanSetInstantQA", "strictJobStatus", "regexpRules"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> QualityAssuranceChecksDtoV2:
        """Create an instance of QualityAssuranceChecksDtoV2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in enabled_checks (list)
        _items = []
        if self.enabled_checks:
            for _item in self.enabled_checks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['enabledChecks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in regexp_rules (list)
        _items = []
        if self.regexp_rules:
            for _item in self.regexp_rules:
                if _item:
                    _items.append(_item.to_dict())
            _dict['regexpRules'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> QualityAssuranceChecksDtoV2:
        """Create an instance of QualityAssuranceChecksDtoV2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return QualityAssuranceChecksDtoV2.parse_obj(obj)

        _obj = QualityAssuranceChecksDtoV2.parse_obj({
            "forbidden_strings": obj.get("forbiddenStrings"),
            "enabled_checks": [EnabledCheckDtoV2.from_dict(_item) for _item in obj.get("enabledChecks")] if obj.get("enabledChecks") is not None else None,
            "exclude_locked_segments": obj.get("excludeLockedSegments"),
            "user_can_set_instant_qa": obj.get("userCanSetInstantQA"),
            "strict_job_status": obj.get("strictJobStatus"),
            "regexp_rules": [RegexpCheckRuleDtoV2.from_dict(_item) for _item in obj.get("regexpRules")] if obj.get("regexpRules") is not None else None
        })
        return _obj

