# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json
from typing import Union
import phrasetms_client.models



from pydantic import BaseModel, Field, StrictStr, validator

class QACheckDtoV2(BaseModel):
    """
    QACheckDtoV2
    """
    type: StrictStr = Field(...)
    name: StrictStr = Field(...)
    __properties = ["type", "name"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('VOID', 'NUMBER', 'STRING', 'REGEX', 'MORAVIA'):
            raise ValueError("must be one of enum values ('VOID', 'NUMBER', 'STRING', 'REGEX', 'MORAVIA')")
        return value

    @validator('name')
    def name_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('emptyTarget', 'inconsistentTranslation', 'joinMarksInconsistency', 'missingNumber', 'segmentNotConfirmed', 'nonConformingTerms', 'multipleSpaces', 'endPunctuation', 'targetLength', 'absoluteTargetLength', 'relativeTargetLength', 'inconsistentFormatting', 'unresolvedComment', 'emptyPairTags', 'strictJobStatus', 'forbiddenStringsEnabled', 'excludeLockedSegments', 'ignoreNotApprovedTerms', 'spellCheck', 'repeatedWords', 'inconsistentTagContent', 'emptyTagContent', 'malformed', 'forbiddenTerms', 'targetLengthPercent', 'targetLengthPerSegment', 'newerAtLowerLevel', 'leadingAndTrailingSpaces', 'targetSourceIdentical', 'ignoreInAllWorkflowSteps', 'regexp', 'unmodifiedFuzzyTranslation', 'unmodifiedFuzzyTranslationTM', 'unmodifiedFuzzyTranslationMTNT', 'moravia', 'extraNumbers', 'nestedTags'):
            raise ValueError("must be one of enum values ('emptyTarget', 'inconsistentTranslation', 'joinMarksInconsistency', 'missingNumber', 'segmentNotConfirmed', 'nonConformingTerms', 'multipleSpaces', 'endPunctuation', 'targetLength', 'absoluteTargetLength', 'relativeTargetLength', 'inconsistentFormatting', 'unresolvedComment', 'emptyPairTags', 'strictJobStatus', 'forbiddenStringsEnabled', 'excludeLockedSegments', 'ignoreNotApprovedTerms', 'spellCheck', 'repeatedWords', 'inconsistentTagContent', 'emptyTagContent', 'malformed', 'forbiddenTerms', 'targetLengthPercent', 'targetLengthPerSegment', 'newerAtLowerLevel', 'leadingAndTrailingSpaces', 'targetSourceIdentical', 'ignoreInAllWorkflowSteps', 'regexp', 'unmodifiedFuzzyTranslation', 'unmodifiedFuzzyTranslationTM', 'unmodifiedFuzzyTranslationMTNT', 'moravia', 'extraNumbers', 'nestedTags')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    # JSON field name that stores the object type
    __discriminator_property_name = 'type'

    # discriminator mappings
    __discriminator_value_class_map = {
        'MORAVIA': 'MORAVIA',
        'NUMBER': 'NUMBER',
        'REGEX': 'REGEX',
        'STRING': 'STRING',
        'VOID': 'VOID'
    }

    @classmethod
    def get_discriminator_value(cls, obj: dict) -> str:
        """Returns the discriminator value (object type) of the data"""
        discriminator_value = obj[cls.__discriminator_property_name]
        if discriminator_value:
            return cls.__discriminator_value_class_map.get(discriminator_value)
        else:
            return None

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Union(MORAVIA, NUMBER, REGEX, STRING, VOID):  # noqa: F821
        """Create an instance of QACheckDtoV2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Union(MORAVIA, NUMBER, REGEX, STRING, VOID):  # noqa: F821
        """Create an instance of QACheckDtoV2 from a dict"""
        # look up the object type based on discriminator mapping
        object_type = cls.get_discriminator_value(obj)
        if object_type:
            klass = getattr(phrasetms_client.models, object_type)
            return klass.from_dict(obj)
        else:
            raise ValueError("QACheckDtoV2 failed to lookup discriminator value from " +
                             json.dumps(obj) + ". Discriminator property name: " + cls.__discriminator_property_name +
                             ", mapping: " + json.dumps(cls.__discriminator_value_class_map))

