# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, conint, conlist, constr
from phrasetms_client.models.substitute_dto import SubstituteDto

class PseudoTranslateActionDto(BaseModel):
    """
    PseudoTranslateActionDto
    """
    replacement: Optional[constr(strict=True, max_length=10, min_length=1)] = None
    prefix: Optional[StrictStr] = None
    suffix: Optional[StrictStr] = None
    length: Optional[Union[StrictFloat, StrictInt]] = None
    key_hash_prefix_len: Optional[conint(strict=True, le=18, ge=0)] = Field(None, alias="keyHashPrefixLen")
    substitution: Optional[conlist(SubstituteDto, max_items=100, min_items=1)] = None
    __properties = ["replacement", "prefix", "suffix", "length", "keyHashPrefixLen", "substitution"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PseudoTranslateActionDto:
        """Create an instance of PseudoTranslateActionDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in substitution (list)
        _items = []
        if self.substitution:
            for _item in self.substitution:
                if _item:
                    _items.append(_item.to_dict())
            _dict['substitution'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PseudoTranslateActionDto:
        """Create an instance of PseudoTranslateActionDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PseudoTranslateActionDto.parse_obj(obj)

        _obj = PseudoTranslateActionDto.parse_obj({
            "replacement": obj.get("replacement"),
            "prefix": obj.get("prefix"),
            "suffix": obj.get("suffix"),
            "length": obj.get("length"),
            "key_hash_prefix_len": obj.get("keyHashPrefixLen"),
            "substitution": [SubstituteDto.from_dict(_item) for _item in obj.get("substitution")] if obj.get("substitution") is not None else None
        })
        return _obj

