# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from phrasetms_client.models.trans_memory_dto_v3 import TransMemoryDtoV3
from phrasetms_client.models.workflow_step_reference_v3 import WorkflowStepReferenceV3

class ProjectTransMemoryDtoV3(BaseModel):
    """
    ProjectTransMemoryDtoV3
    """
    trans_memory: Optional[TransMemoryDtoV3] = Field(None, alias="transMemory")
    penalty: Optional[Union[StrictFloat, StrictInt]] = None
    apply_penalty_to101_only: Optional[StrictBool] = Field(None, alias="applyPenaltyTo101Only")
    target_locale: Optional[StrictStr] = Field(None, alias="targetLocale")
    workflow_step: Optional[WorkflowStepReferenceV3] = Field(None, alias="workflowStep")
    read_mode: Optional[StrictBool] = Field(None, alias="readMode")
    write_mode: Optional[StrictBool] = Field(None, alias="writeMode")
    order: Optional[StrictInt] = None
    __properties = ["transMemory", "penalty", "applyPenaltyTo101Only", "targetLocale", "workflowStep", "readMode", "writeMode", "order"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ProjectTransMemoryDtoV3:
        """Create an instance of ProjectTransMemoryDtoV3 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of trans_memory
        if self.trans_memory:
            _dict['transMemory'] = self.trans_memory.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workflow_step
        if self.workflow_step:
            _dict['workflowStep'] = self.workflow_step.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProjectTransMemoryDtoV3:
        """Create an instance of ProjectTransMemoryDtoV3 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ProjectTransMemoryDtoV3.parse_obj(obj)

        _obj = ProjectTransMemoryDtoV3.parse_obj({
            "trans_memory": TransMemoryDtoV3.from_dict(obj.get("transMemory")) if obj.get("transMemory") is not None else None,
            "penalty": obj.get("penalty"),
            "apply_penalty_to101_only": obj.get("applyPenaltyTo101Only"),
            "target_locale": obj.get("targetLocale"),
            "workflow_step": WorkflowStepReferenceV3.from_dict(obj.get("workflowStep")) if obj.get("workflowStep") is not None else None,
            "read_mode": obj.get("readMode"),
            "write_mode": obj.get("writeMode"),
            "order": obj.get("order")
        })
        return _obj

