# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, conint

class ProjectTemplateNotifyProviderDto(BaseModel):
    """
    ProjectTemplateNotifyProviderDto
    """
    organization_email_template: Dict[str, Any] = Field(..., alias="organizationEmailTemplate")
    notification_interval_in_minutes: Optional[conint(strict=True, le=1440, ge=0)] = Field(None, alias="notificationIntervalInMinutes")
    __properties = ["organizationEmailTemplate", "notificationIntervalInMinutes"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ProjectTemplateNotifyProviderDto:
        """Create an instance of ProjectTemplateNotifyProviderDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProjectTemplateNotifyProviderDto:
        """Create an instance of ProjectTemplateNotifyProviderDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ProjectTemplateNotifyProviderDto.parse_obj(obj)

        _obj = ProjectTemplateNotifyProviderDto.parse_obj({
            "organization_email_template": obj.get("organizationEmailTemplate"),
            "notification_interval_in_minutes": obj.get("notificationIntervalInMinutes")
        })
        return _obj

