# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, constr
from phrasetms_client.models.id_reference import IdReference
from phrasetms_client.models.project_template_notify_provider_dto import ProjectTemplateNotifyProviderDto
from phrasetms_client.models.project_template_workflow_settings_assigned_to_dto import ProjectTemplateWorkflowSettingsAssignedToDto
from phrasetms_client.models.uid_reference import UidReference
from phrasetms_client.models.workflow_step_settings_edit_dto import WorkflowStepSettingsEditDto

class ProjectTemplateEditDto(BaseModel):
    """
    ProjectTemplateEditDto
    """
    name: Optional[constr(strict=True, max_length=255, min_length=0)] = None
    template_name: constr(strict=True, max_length=255, min_length=0) = Field(..., alias="templateName")
    source_lang: Optional[StrictStr] = Field(None, alias="sourceLang")
    target_langs: Optional[conlist(StrictStr)] = Field(None, alias="targetLangs")
    use_dynamic_title: Optional[StrictBool] = Field(None, alias="useDynamicTitle")
    dynamic_title: Optional[constr(strict=True, max_length=255, min_length=0)] = Field(None, alias="dynamicTitle")
    notify_provider: Optional[ProjectTemplateNotifyProviderDto] = Field(None, alias="notifyProvider")
    work_flow_settings: Optional[conlist(WorkflowStepSettingsEditDto)] = Field(None, alias="workFlowSettings")
    client: Optional[IdReference] = None
    cost_center: Optional[IdReference] = Field(None, alias="costCenter")
    business_unit: Optional[IdReference] = Field(None, alias="businessUnit")
    domain: Optional[IdReference] = None
    sub_domain: Optional[IdReference] = Field(None, alias="subDomain")
    vendor: Optional[IdReference] = None
    import_settings: Optional[UidReference] = Field(None, alias="importSettings")
    note: Optional[constr(strict=True, max_length=4096, min_length=0)] = None
    file_handover: Optional[StrictBool] = Field(None, alias="fileHandover", description="Default: false")
    assigned_to: Optional[conlist(ProjectTemplateWorkflowSettingsAssignedToDto)] = Field(None, alias="assignedTo", description="only use for projects without workflows; otherwise specify in the workflowSettings object")
    __properties = ["name", "templateName", "sourceLang", "targetLangs", "useDynamicTitle", "dynamicTitle", "notifyProvider", "workFlowSettings", "client", "costCenter", "businessUnit", "domain", "subDomain", "vendor", "importSettings", "note", "fileHandover", "assignedTo"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ProjectTemplateEditDto:
        """Create an instance of ProjectTemplateEditDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of notify_provider
        if self.notify_provider:
            _dict['notifyProvider'] = self.notify_provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in work_flow_settings (list)
        _items = []
        if self.work_flow_settings:
            for _item in self.work_flow_settings:
                if _item:
                    _items.append(_item.to_dict())
            _dict['workFlowSettings'] = _items
        # override the default output from pydantic by calling `to_dict()` of client
        if self.client:
            _dict['client'] = self.client.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cost_center
        if self.cost_center:
            _dict['costCenter'] = self.cost_center.to_dict()
        # override the default output from pydantic by calling `to_dict()` of business_unit
        if self.business_unit:
            _dict['businessUnit'] = self.business_unit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of domain
        if self.domain:
            _dict['domain'] = self.domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sub_domain
        if self.sub_domain:
            _dict['subDomain'] = self.sub_domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of vendor
        if self.vendor:
            _dict['vendor'] = self.vendor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of import_settings
        if self.import_settings:
            _dict['importSettings'] = self.import_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in assigned_to (list)
        _items = []
        if self.assigned_to:
            for _item in self.assigned_to:
                if _item:
                    _items.append(_item.to_dict())
            _dict['assignedTo'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProjectTemplateEditDto:
        """Create an instance of ProjectTemplateEditDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ProjectTemplateEditDto.parse_obj(obj)

        _obj = ProjectTemplateEditDto.parse_obj({
            "name": obj.get("name"),
            "template_name": obj.get("templateName"),
            "source_lang": obj.get("sourceLang"),
            "target_langs": obj.get("targetLangs"),
            "use_dynamic_title": obj.get("useDynamicTitle"),
            "dynamic_title": obj.get("dynamicTitle"),
            "notify_provider": ProjectTemplateNotifyProviderDto.from_dict(obj.get("notifyProvider")) if obj.get("notifyProvider") is not None else None,
            "work_flow_settings": [WorkflowStepSettingsEditDto.from_dict(_item) for _item in obj.get("workFlowSettings")] if obj.get("workFlowSettings") is not None else None,
            "client": IdReference.from_dict(obj.get("client")) if obj.get("client") is not None else None,
            "cost_center": IdReference.from_dict(obj.get("costCenter")) if obj.get("costCenter") is not None else None,
            "business_unit": IdReference.from_dict(obj.get("businessUnit")) if obj.get("businessUnit") is not None else None,
            "domain": IdReference.from_dict(obj.get("domain")) if obj.get("domain") is not None else None,
            "sub_domain": IdReference.from_dict(obj.get("subDomain")) if obj.get("subDomain") is not None else None,
            "vendor": IdReference.from_dict(obj.get("vendor")) if obj.get("vendor") is not None else None,
            "import_settings": UidReference.from_dict(obj.get("importSettings")) if obj.get("importSettings") is not None else None,
            "note": obj.get("note"),
            "file_handover": obj.get("fileHandover"),
            "assigned_to": [ProjectTemplateWorkflowSettingsAssignedToDto.from_dict(_item) for _item in obj.get("assignedTo")] if obj.get("assignedTo") is not None else None
        })
        return _obj

