# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool
from phrasetms_client.models.machine_translation_settings_dto import MachineTranslationSettingsDto
from phrasetms_client.models.non_translatable_settings_dto import NonTranslatableSettingsDto
from phrasetms_client.models.repetitions_settings_dto import RepetitionsSettingsDto
from phrasetms_client.models.translation_memory_settings_dto import TranslationMemorySettingsDto

class PreTranslateSettingsV3Dto(BaseModel):
    """
    Pre-translate settings
    """
    pre_translate_on_job_creation: Optional[StrictBool] = Field(None, alias="preTranslateOnJobCreation", description="Pre-translate & set job to completed: Pre-translate on job creation. Default: false")
    set_job_status_completed: Optional[StrictBool] = Field(None, alias="setJobStatusCompleted", description="Pre-translate & set job to completed: Set job to completed once pre-translated. Default: false")
    set_job_status_completed_when_confirmed: Optional[StrictBool] = Field(None, alias="setJobStatusCompletedWhenConfirmed", description="Pre-translate & set job to completed when all segments confirmed: Set job to completed once pre-translated and all segments are confirmed. Default: false")
    set_project_status_completed: Optional[StrictBool] = Field(None, alias="setProjectStatusCompleted", description="Pre-translate & set job to completed: Set project to completed once all jobs pre-translated.         Default: false")
    overwrite_existing_translations: Optional[StrictBool] = Field(None, alias="overwriteExistingTranslations", description="Overwrite existing translations in target segments. Default: false")
    translation_memory_settings: Optional[TranslationMemorySettingsDto] = Field(None, alias="translationMemorySettings")
    machine_translation_settings: Optional[MachineTranslationSettingsDto] = Field(None, alias="machineTranslationSettings")
    non_translatable_settings: Optional[NonTranslatableSettingsDto] = Field(None, alias="nonTranslatableSettings")
    repetitions_settings: Optional[RepetitionsSettingsDto] = Field(None, alias="repetitionsSettings")
    __properties = ["preTranslateOnJobCreation", "setJobStatusCompleted", "setJobStatusCompletedWhenConfirmed", "setProjectStatusCompleted", "overwriteExistingTranslations", "translationMemorySettings", "machineTranslationSettings", "nonTranslatableSettings", "repetitionsSettings"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PreTranslateSettingsV3Dto:
        """Create an instance of PreTranslateSettingsV3Dto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of translation_memory_settings
        if self.translation_memory_settings:
            _dict['translationMemorySettings'] = self.translation_memory_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of machine_translation_settings
        if self.machine_translation_settings:
            _dict['machineTranslationSettings'] = self.machine_translation_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of non_translatable_settings
        if self.non_translatable_settings:
            _dict['nonTranslatableSettings'] = self.non_translatable_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of repetitions_settings
        if self.repetitions_settings:
            _dict['repetitionsSettings'] = self.repetitions_settings.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PreTranslateSettingsV3Dto:
        """Create an instance of PreTranslateSettingsV3Dto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PreTranslateSettingsV3Dto.parse_obj(obj)

        _obj = PreTranslateSettingsV3Dto.parse_obj({
            "pre_translate_on_job_creation": obj.get("preTranslateOnJobCreation"),
            "set_job_status_completed": obj.get("setJobStatusCompleted"),
            "set_job_status_completed_when_confirmed": obj.get("setJobStatusCompletedWhenConfirmed"),
            "set_project_status_completed": obj.get("setProjectStatusCompleted"),
            "overwrite_existing_translations": obj.get("overwriteExistingTranslations"),
            "translation_memory_settings": TranslationMemorySettingsDto.from_dict(obj.get("translationMemorySettings")) if obj.get("translationMemorySettings") is not None else None,
            "machine_translation_settings": MachineTranslationSettingsDto.from_dict(obj.get("machineTranslationSettings")) if obj.get("machineTranslationSettings") is not None else None,
            "non_translatable_settings": NonTranslatableSettingsDto.from_dict(obj.get("nonTranslatableSettings")) if obj.get("nonTranslatableSettings") is not None else None,
            "repetitions_settings": RepetitionsSettingsDto.from_dict(obj.get("repetitionsSettings")) if obj.get("repetitionsSettings") is not None else None
        })
        return _obj

