# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, validator
from phrasetms_client.models.pre_translate_job_settings_dto import PreTranslateJobSettingsDto
from phrasetms_client.models.uid_reference import UidReference

class PreTranslateJobsV2Dto(BaseModel):
    """
    PreTranslateJobsV2Dto
    """
    jobs: conlist(UidReference, max_items=100, min_items=1) = Field(..., description="Jobs to be pre-translated")
    segment_filters: Optional[conlist(StrictStr)] = Field(None, alias="segmentFilters")
    use_project_pre_translate_settings: Optional[StrictBool] = Field(None, alias="useProjectPreTranslateSettings", description="If pre-translate settings from project should be used. If true, preTranslateSettings values are ignored. Default: false")
    callback_url: Optional[StrictStr] = Field(None, alias="callbackUrl")
    pre_translate_settings: Optional[PreTranslateJobSettingsDto] = Field(None, alias="preTranslateSettings")
    __properties = ["jobs", "segmentFilters", "useProjectPreTranslateSettings", "callbackUrl", "preTranslateSettings"]

    @validator('segment_filters')
    def segment_filters_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in ('LOCKED', 'NOT_LOCKED'):
                raise ValueError("each list item must be one of ('LOCKED', 'NOT_LOCKED')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PreTranslateJobsV2Dto:
        """Create an instance of PreTranslateJobsV2Dto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in jobs (list)
        _items = []
        if self.jobs:
            for _item in self.jobs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['jobs'] = _items
        # override the default output from pydantic by calling `to_dict()` of pre_translate_settings
        if self.pre_translate_settings:
            _dict['preTranslateSettings'] = self.pre_translate_settings.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PreTranslateJobsV2Dto:
        """Create an instance of PreTranslateJobsV2Dto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PreTranslateJobsV2Dto.parse_obj(obj)

        _obj = PreTranslateJobsV2Dto.parse_obj({
            "jobs": [UidReference.from_dict(_item) for _item in obj.get("jobs")] if obj.get("jobs") is not None else None,
            "segment_filters": obj.get("segmentFilters"),
            "use_project_pre_translate_settings": obj.get("useProjectPreTranslateSettings"),
            "callback_url": obj.get("callbackUrl"),
            "pre_translate_settings": PreTranslateJobSettingsDto.from_dict(obj.get("preTranslateSettings")) if obj.get("preTranslateSettings") is not None else None
        })
        return _obj

