# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool
from phrasetms_client.models.job_machine_translation_settings_dto import JobMachineTranslationSettingsDto
from phrasetms_client.models.job_non_translatable_settings_dto import JobNonTranslatableSettingsDto
from phrasetms_client.models.job_translation_memory_settings_dto import JobTranslationMemorySettingsDto

class PreTranslateJobSettingsDto(BaseModel):
    """
    Pre-translate settings
    """
    auto_propagate_repetitions: Optional[StrictBool] = Field(None, alias="autoPropagateRepetitions", description="Propagate repetitions. Default: false")
    confirm_repetitions: Optional[StrictBool] = Field(None, alias="confirmRepetitions", description="Set segment status to confirmed for: Repetitions. Default: false")
    set_job_status_completed: Optional[StrictBool] = Field(None, alias="setJobStatusCompleted", description="Pre-translate & set job to completed: Set job to completed once pre-translated. Default: false")
    set_job_status_completed_when_confirmed: Optional[StrictBool] = Field(None, alias="setJobStatusCompletedWhenConfirmed", description="Pre-translate & set job to completed when all segments confirmed: Set job to completed once pre-translated and all segments are confirmed. Default: false")
    set_project_status_completed: Optional[StrictBool] = Field(None, alias="setProjectStatusCompleted", description="Pre-translate & set job to completed: Set project to completed once all jobs pre-translated.         Default: false")
    overwrite_existing_translations: Optional[StrictBool] = Field(None, alias="overwriteExistingTranslations", description="Overwrite existing translations in target segments. Default: false")
    translation_memory_settings: Optional[JobTranslationMemorySettingsDto] = Field(None, alias="translationMemorySettings")
    machine_translation_settings: Optional[JobMachineTranslationSettingsDto] = Field(None, alias="machineTranslationSettings")
    non_translatable_settings: Optional[JobNonTranslatableSettingsDto] = Field(None, alias="nonTranslatableSettings")
    __properties = ["autoPropagateRepetitions", "confirmRepetitions", "setJobStatusCompleted", "setJobStatusCompletedWhenConfirmed", "setProjectStatusCompleted", "overwriteExistingTranslations", "translationMemorySettings", "machineTranslationSettings", "nonTranslatableSettings"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PreTranslateJobSettingsDto:
        """Create an instance of PreTranslateJobSettingsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of translation_memory_settings
        if self.translation_memory_settings:
            _dict['translationMemorySettings'] = self.translation_memory_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of machine_translation_settings
        if self.machine_translation_settings:
            _dict['machineTranslationSettings'] = self.machine_translation_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of non_translatable_settings
        if self.non_translatable_settings:
            _dict['nonTranslatableSettings'] = self.non_translatable_settings.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PreTranslateJobSettingsDto:
        """Create an instance of PreTranslateJobSettingsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PreTranslateJobSettingsDto.parse_obj(obj)

        _obj = PreTranslateJobSettingsDto.parse_obj({
            "auto_propagate_repetitions": obj.get("autoPropagateRepetitions"),
            "confirm_repetitions": obj.get("confirmRepetitions"),
            "set_job_status_completed": obj.get("setJobStatusCompleted"),
            "set_job_status_completed_when_confirmed": obj.get("setJobStatusCompletedWhenConfirmed"),
            "set_project_status_completed": obj.get("setProjectStatusCompleted"),
            "overwrite_existing_translations": obj.get("overwriteExistingTranslations"),
            "translation_memory_settings": JobTranslationMemorySettingsDto.from_dict(obj.get("translationMemorySettings")) if obj.get("translationMemorySettings") is not None else None,
            "machine_translation_settings": JobMachineTranslationSettingsDto.from_dict(obj.get("machineTranslationSettings")) if obj.get("machineTranslationSettings") is not None else None,
            "non_translatable_settings": JobNonTranslatableSettingsDto.from_dict(obj.get("nonTranslatableSettings")) if obj.get("nonTranslatableSettings") is not None else None
        })
        return _obj

