# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator

class PoSettingsDto(BaseModel):
    """
    PoSettingsDto
    """
    tag_regexp: Optional[StrictStr] = Field(None, alias="tagRegexp")
    export_multiline: Optional[StrictBool] = Field(None, alias="exportMultiline", description="Default: true")
    html_sub_filter: Optional[StrictBool] = Field(None, alias="htmlSubFilter", description="Default: false")
    segment: Optional[StrictBool] = Field(None, description="Default: false")
    markup_sub_filter_translatable: Optional[StrictStr] = Field(None, alias="markupSubFilterTranslatable")
    markup_sub_filter_non_translatable: Optional[StrictStr] = Field(None, alias="markupSubFilterNonTranslatable")
    save_confirmed_segments: Optional[StrictBool] = Field(None, alias="saveConfirmedSegments")
    import_set_segment_confirmed_when: Optional[StrictStr] = Field(None, alias="importSetSegmentConfirmedWhen")
    import_set_segment_locked_when: Optional[StrictStr] = Field(None, alias="importSetSegmentLockedWhen")
    export_confirmed_locked: Optional[StrictStr] = Field(None, alias="exportConfirmedLocked")
    export_confirmed_not_locked: Optional[StrictStr] = Field(None, alias="exportConfirmedNotLocked")
    export_not_confirmed_locked: Optional[StrictStr] = Field(None, alias="exportNotConfirmedLocked")
    export_not_confirmed_not_locked: Optional[StrictStr] = Field(None, alias="exportNotConfirmedNotLocked")
    icu_sub_filter: Optional[StrictBool] = Field(None, alias="icuSubFilter", description="Default: `false`")
    __properties = ["tagRegexp", "exportMultiline", "htmlSubFilter", "segment", "markupSubFilterTranslatable", "markupSubFilterNonTranslatable", "saveConfirmedSegments", "importSetSegmentConfirmedWhen", "importSetSegmentLockedWhen", "exportConfirmedLocked", "exportConfirmedNotLocked", "exportNotConfirmedLocked", "exportNotConfirmedNotLocked", "icuSubFilter"]

    @validator('import_set_segment_confirmed_when')
    def import_set_segment_confirmed_when_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('FUZZY', 'NONFUZZY'):
            raise ValueError("must be one of enum values ('FUZZY', 'NONFUZZY')")
        return value

    @validator('import_set_segment_locked_when')
    def import_set_segment_locked_when_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('FUZZY', 'NONFUZZY'):
            raise ValueError("must be one of enum values ('FUZZY', 'NONFUZZY')")
        return value

    @validator('export_confirmed_locked')
    def export_confirmed_locked_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('FUZZY', 'NONFUZZY'):
            raise ValueError("must be one of enum values ('FUZZY', 'NONFUZZY')")
        return value

    @validator('export_confirmed_not_locked')
    def export_confirmed_not_locked_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('FUZZY', 'NONFUZZY'):
            raise ValueError("must be one of enum values ('FUZZY', 'NONFUZZY')")
        return value

    @validator('export_not_confirmed_locked')
    def export_not_confirmed_locked_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('FUZZY', 'NONFUZZY'):
            raise ValueError("must be one of enum values ('FUZZY', 'NONFUZZY')")
        return value

    @validator('export_not_confirmed_not_locked')
    def export_not_confirmed_not_locked_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('FUZZY', 'NONFUZZY'):
            raise ValueError("must be one of enum values ('FUZZY', 'NONFUZZY')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PoSettingsDto:
        """Create an instance of PoSettingsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PoSettingsDto:
        """Create an instance of PoSettingsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PoSettingsDto.parse_obj(obj)

        _obj = PoSettingsDto.parse_obj({
            "tag_regexp": obj.get("tagRegexp"),
            "export_multiline": obj.get("exportMultiline"),
            "html_sub_filter": obj.get("htmlSubFilter"),
            "segment": obj.get("segment"),
            "markup_sub_filter_translatable": obj.get("markupSubFilterTranslatable"),
            "markup_sub_filter_non_translatable": obj.get("markupSubFilterNonTranslatable"),
            "save_confirmed_segments": obj.get("saveConfirmedSegments"),
            "import_set_segment_confirmed_when": obj.get("importSetSegmentConfirmedWhen"),
            "import_set_segment_locked_when": obj.get("importSetSegmentLockedWhen"),
            "export_confirmed_locked": obj.get("exportConfirmedLocked"),
            "export_confirmed_not_locked": obj.get("exportConfirmedNotLocked"),
            "export_not_confirmed_locked": obj.get("exportNotConfirmedLocked"),
            "export_not_confirmed_not_locked": obj.get("exportNotConfirmedNotLocked"),
            "icu_sub_filter": obj.get("icuSubFilter")
        })
        return _obj

