# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, conint
from phrasetms_client.models.reference_correlation import ReferenceCorrelation

class PlainReferences(BaseModel):
    """
    PlainReferences
    """
    task_id: Optional[StrictStr] = Field(None, alias="taskId")
    job_part_uid: Optional[StrictStr] = Field(None, alias="jobPartUid")
    trans_group_id: conint(strict=True, ge=0) = Field(..., alias="transGroupId")
    segment_id: StrictStr = Field(..., alias="segmentId")
    conversation_title: Optional[StrictStr] = Field(None, alias="conversationTitle")
    conversation_title_offset: Optional[conint(strict=True, ge=0)] = Field(None, alias="conversationTitleOffset")
    commented_text: Optional[StrictStr] = Field(None, alias="commentedText")
    correlation: Optional[ReferenceCorrelation] = None
    __properties = ["taskId", "jobPartUid", "transGroupId", "segmentId", "conversationTitle", "conversationTitleOffset", "commentedText", "correlation"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PlainReferences:
        """Create an instance of PlainReferences from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "task_id",
                            "job_part_uid",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of correlation
        if self.correlation:
            _dict['correlation'] = self.correlation.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PlainReferences:
        """Create an instance of PlainReferences from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PlainReferences.parse_obj(obj)

        _obj = PlainReferences.parse_obj({
            "task_id": obj.get("taskId"),
            "job_part_uid": obj.get("jobPartUid"),
            "trans_group_id": obj.get("transGroupId"),
            "segment_id": obj.get("segmentId"),
            "conversation_title": obj.get("conversationTitle"),
            "conversation_title_offset": obj.get("conversationTitleOffset"),
            "commented_text": obj.get("commentedText"),
            "correlation": ReferenceCorrelation.from_dict(obj.get("correlation")) if obj.get("correlation") is not None else None
        })
        return _obj

