# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from phrasetms_client.models.discount_settings_dto import DiscountSettingsDto
from phrasetms_client.models.net_rate_scheme_workflow_step_reference import NetRateSchemeWorkflowStepReference
from phrasetms_client.models.organization_reference import OrganizationReference
from phrasetms_client.models.user_reference import UserReference

class NetRateScheme(BaseModel):
    """
    NetRateScheme
    """
    id: Optional[StrictStr] = None
    uid: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    organization: Optional[OrganizationReference] = None
    date_created: Optional[datetime] = Field(None, alias="dateCreated")
    created_by: Optional[UserReference] = Field(None, alias="createdBy")
    workflow_step_net_schemes: Optional[conlist(NetRateSchemeWorkflowStepReference)] = Field(None, alias="workflowStepNetSchemes")
    rates: Optional[DiscountSettingsDto] = None
    __properties = ["id", "uid", "name", "organization", "dateCreated", "createdBy", "workflowStepNetSchemes", "rates"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NetRateScheme:
        """Create an instance of NetRateScheme from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict['organization'] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by
        if self.created_by:
            _dict['createdBy'] = self.created_by.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in workflow_step_net_schemes (list)
        _items = []
        if self.workflow_step_net_schemes:
            for _item in self.workflow_step_net_schemes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['workflowStepNetSchemes'] = _items
        # override the default output from pydantic by calling `to_dict()` of rates
        if self.rates:
            _dict['rates'] = self.rates.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> NetRateScheme:
        """Create an instance of NetRateScheme from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return NetRateScheme.parse_obj(obj)

        _obj = NetRateScheme.parse_obj({
            "id": obj.get("id"),
            "uid": obj.get("uid"),
            "name": obj.get("name"),
            "organization": OrganizationReference.from_dict(obj.get("organization")) if obj.get("organization") is not None else None,
            "date_created": obj.get("dateCreated"),
            "created_by": UserReference.from_dict(obj.get("createdBy")) if obj.get("createdBy") is not None else None,
            "workflow_step_net_schemes": [NetRateSchemeWorkflowStepReference.from_dict(_item) for _item in obj.get("workflowStepNetSchemes")] if obj.get("workflowStepNetSchemes") is not None else None,
            "rates": DiscountSettingsDto.from_dict(obj.get("rates")) if obj.get("rates") is not None else None
        })
        return _obj

