# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional, Union
from pydantic import (
    BaseModel,
    Field,
    StrictBool,
    StrictInt,
    StrictStr,
    conbytes,
    conlist,
    constr,
    validator,
)


class MultipartFile(BaseModel):
    """
    MultipartFile
    """

    local_path: StrictStr = Field(...)
    empty: Optional[StrictBool] = None
    bytes: Optional[conlist(Union[conbytes(strict=True), constr(strict=True)])] = None
    size: Optional[StrictInt] = None
    input_stream: Optional[Dict[str, Any]] = Field(None, alias="inputStream")
    content_type: Optional[StrictStr] = Field(None, alias="contentType")
    original_filename: Optional[StrictStr] = Field(None, alias="originalFilename")
    __properties = [
        "local_path",
        "empty",
        "bytes",
        "size",
        "inputStream",
        "contentType",
        "originalFilename",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MultipartFile:
        """Create an instance of MultipartFile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MultipartFile:
        """Create an instance of MultipartFile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MultipartFile.parse_obj(obj)

        _obj = MultipartFile.parse_obj(
            {
                "local_path": obj.get("local_path"),
                "empty": obj.get("empty"),
                "bytes": obj.get("bytes"),
                "size": obj.get("size"),
                "input_stream": obj.get("inputStream"),
                "content_type": obj.get("contentType"),
                "original_filename": obj.get("originalFilename"),
            }
        )
        return _obj
