# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr, validator

class MultilingualCsvSettingsDto(BaseModel):
    """
    MultilingualCsvSettingsDto
    """
    source_columns: Optional[StrictStr] = Field(None, alias="sourceColumns")
    target_columns: Optional[StrictStr] = Field(None, alias="targetColumns")
    context_note_columns: Optional[StrictStr] = Field(None, alias="contextNoteColumns")
    context_key_columns: Optional[StrictStr] = Field(None, alias="contextKeyColumns")
    tag_regexp: Optional[StrictStr] = Field(None, alias="tagRegexp")
    html_sub_filter: Optional[StrictBool] = Field(None, alias="htmlSubFilter", description="Default: false")
    segmentation: Optional[StrictBool] = Field(None, description="Default: true")
    delimiter: Optional[constr(strict=True, max_length=255, min_length=0)] = Field(None, description="Default: ,")
    delimiter_type: Optional[constr(strict=True, max_length=255, min_length=0)] = Field(None, alias="delimiterType", description="Default: COMMA")
    import_rows: Optional[StrictStr] = Field(None, alias="importRows")
    max_len_columns: Optional[StrictStr] = Field(None, alias="maxLenColumns")
    all_target_columns: Optional[Dict[str, StrictStr]] = Field(None, alias="allTargetColumns", description="Format: \"language\":\"column\"; example: {\"en\": \"A\", \"sk\": \"B\"}")
    non_empty_segment_action: Optional[StrictStr] = Field(None, alias="nonEmptySegmentAction")
    save_confirmed_segments_to_tm: Optional[StrictBool] = Field(None, alias="saveConfirmedSegmentsToTm")
    __properties = ["sourceColumns", "targetColumns", "contextNoteColumns", "contextKeyColumns", "tagRegexp", "htmlSubFilter", "segmentation", "delimiter", "delimiterType", "importRows", "maxLenColumns", "allTargetColumns", "nonEmptySegmentAction", "saveConfirmedSegmentsToTm"]

    @validator('delimiter_type')
    def delimiter_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('TAB', 'COMMA', 'SEMICOLON', 'OTHER'):
            raise ValueError("must be one of enum values ('TAB', 'COMMA', 'SEMICOLON', 'OTHER')")
        return value

    @validator('non_empty_segment_action')
    def non_empty_segment_action_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('NONE', 'CONFIRM', 'LOCK', 'CONFIRM_LOCK'):
            raise ValueError("must be one of enum values ('NONE', 'CONFIRM', 'LOCK', 'CONFIRM_LOCK')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MultilingualCsvSettingsDto:
        """Create an instance of MultilingualCsvSettingsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MultilingualCsvSettingsDto:
        """Create an instance of MultilingualCsvSettingsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MultilingualCsvSettingsDto.parse_obj(obj)

        _obj = MultilingualCsvSettingsDto.parse_obj({
            "source_columns": obj.get("sourceColumns"),
            "target_columns": obj.get("targetColumns"),
            "context_note_columns": obj.get("contextNoteColumns"),
            "context_key_columns": obj.get("contextKeyColumns"),
            "tag_regexp": obj.get("tagRegexp"),
            "html_sub_filter": obj.get("htmlSubFilter"),
            "segmentation": obj.get("segmentation"),
            "delimiter": obj.get("delimiter"),
            "delimiter_type": obj.get("delimiterType"),
            "import_rows": obj.get("importRows"),
            "max_len_columns": obj.get("maxLenColumns"),
            "all_target_columns": obj.get("allTargetColumns"),
            "non_empty_segment_action": obj.get("nonEmptySegmentAction"),
            "save_confirmed_segments_to_tm": obj.get("saveConfirmedSegmentsToTm")
        })
        return _obj

