# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class MifSettingsDto(BaseModel):
    """
    MifSettingsDto
    """
    extract_body_pages: Optional[StrictBool] = Field(None, alias="extractBodyPages", description="Default: true")
    extract_reference_pages: Optional[StrictBool] = Field(None, alias="extractReferencePages", description="Default: false")
    extract_master_pages: Optional[StrictBool] = Field(None, alias="extractMasterPages", description="Default: true")
    extract_hidden_pages: Optional[StrictBool] = Field(None, alias="extractHiddenPages", description="Default: false")
    extract_variables: Optional[StrictBool] = Field(None, alias="extractVariables", description="Default: false")
    extract_index_markers: Optional[StrictBool] = Field(None, alias="extractIndexMarkers", description="Default: true")
    extract_links: Optional[StrictBool] = Field(None, alias="extractLinks", description="Default: false")
    extract_x_ref_def: Optional[StrictBool] = Field(None, alias="extractXRefDef", description="Default: false")
    extract_pgf_num_format: Optional[StrictBool] = Field(None, alias="extractPgfNumFormat", description="Default: true")
    extract_custom_reference_pages: Optional[StrictBool] = Field(None, alias="extractCustomReferencePages", description="Default: true")
    extract_default_reference_pages: Optional[StrictBool] = Field(None, alias="extractDefaultReferencePages", description="Default: false")
    extract_used_variables: Optional[StrictBool] = Field(None, alias="extractUsedVariables", description="Default: true")
    extract_hidden_cond_text: Optional[StrictBool] = Field(None, alias="extractHiddenCondText", description="Default: false")
    extract_used_x_ref_def: Optional[StrictBool] = Field(None, alias="extractUsedXRefDef", description="Default: true")
    extract_used_pgf_num_format: Optional[StrictBool] = Field(None, alias="extractUsedPgfNumFormat", description="Default: true")
    tag_regexp: Optional[StrictStr] = Field(None, alias="tagRegexp")
    __properties = ["extractBodyPages", "extractReferencePages", "extractMasterPages", "extractHiddenPages", "extractVariables", "extractIndexMarkers", "extractLinks", "extractXRefDef", "extractPgfNumFormat", "extractCustomReferencePages", "extractDefaultReferencePages", "extractUsedVariables", "extractHiddenCondText", "extractUsedXRefDef", "extractUsedPgfNumFormat", "tagRegexp"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MifSettingsDto:
        """Create an instance of MifSettingsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MifSettingsDto:
        """Create an instance of MifSettingsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MifSettingsDto.parse_obj(obj)

        _obj = MifSettingsDto.parse_obj({
            "extract_body_pages": obj.get("extractBodyPages"),
            "extract_reference_pages": obj.get("extractReferencePages"),
            "extract_master_pages": obj.get("extractMasterPages"),
            "extract_hidden_pages": obj.get("extractHiddenPages"),
            "extract_variables": obj.get("extractVariables"),
            "extract_index_markers": obj.get("extractIndexMarkers"),
            "extract_links": obj.get("extractLinks"),
            "extract_x_ref_def": obj.get("extractXRefDef"),
            "extract_pgf_num_format": obj.get("extractPgfNumFormat"),
            "extract_custom_reference_pages": obj.get("extractCustomReferencePages"),
            "extract_default_reference_pages": obj.get("extractDefaultReferencePages"),
            "extract_used_variables": obj.get("extractUsedVariables"),
            "extract_hidden_cond_text": obj.get("extractHiddenCondText"),
            "extract_used_x_ref_def": obj.get("extractUsedXRefDef"),
            "extract_used_pgf_num_format": obj.get("extractUsedPgfNumFormat"),
            "tag_regexp": obj.get("tagRegexp")
        })
        return _obj

