# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, validator
from phrasetms_client.models.job_role_dto import JobRoleDto

class MentionableUserDto(BaseModel):
    """
    MentionableUserDto
    """
    first_name: Optional[StrictStr] = Field(None, alias="firstName")
    last_name: Optional[StrictStr] = Field(None, alias="lastName")
    user_name: Optional[StrictStr] = Field(None, alias="userName")
    email: Optional[StrictStr] = None
    role: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    uid: Optional[StrictStr] = None
    unavailable: Optional[StrictBool] = None
    job_roles: Optional[conlist(JobRoleDto)] = Field(None, alias="jobRoles")
    __properties = ["firstName", "lastName", "userName", "email", "role", "id", "uid", "unavailable", "jobRoles"]

    @validator('role')
    def role_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('SYS_ADMIN', 'SYS_ADMIN_READ', 'ADMIN', 'PROJECT_MANAGER', 'LINGUIST', 'GUEST', 'SUBMITTER'):
            raise ValueError("must be one of enum values ('SYS_ADMIN', 'SYS_ADMIN_READ', 'ADMIN', 'PROJECT_MANAGER', 'LINGUIST', 'GUEST', 'SUBMITTER')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MentionableUserDto:
        """Create an instance of MentionableUserDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in job_roles (list)
        _items = []
        if self.job_roles:
            for _item in self.job_roles:
                if _item:
                    _items.append(_item.to_dict())
            _dict['jobRoles'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MentionableUserDto:
        """Create an instance of MentionableUserDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MentionableUserDto.parse_obj(obj)

        _obj = MentionableUserDto.parse_obj({
            "first_name": obj.get("firstName"),
            "last_name": obj.get("lastName"),
            "user_name": obj.get("userName"),
            "email": obj.get("email"),
            "role": obj.get("role"),
            "id": obj.get("id"),
            "uid": obj.get("uid"),
            "unavailable": obj.get("unavailable"),
            "job_roles": [JobRoleDto.from_dict(_item) for _item in obj.get("jobRoles")] if obj.get("jobRoles") is not None else None
        })
        return _obj

