# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, validator
from phrasetms_client.models.mentionable_group_dto import MentionableGroupDto
from phrasetms_client.models.mentionable_user_dto import MentionableUserDto
from phrasetms_client.models.uid_reference import UidReference

class MentionDto(BaseModel):
    """
    MentionDto
    """
    mention_type: StrictStr = Field(..., alias="mentionType")
    mention_group_type: Optional[StrictStr] = Field(None, alias="mentionGroupType")
    uid_reference: Optional[UidReference] = Field(None, alias="uidReference")
    user_references: Optional[conlist(MentionableUserDto)] = Field(None, alias="userReferences")
    mentionable_group: Optional[MentionableGroupDto] = Field(None, alias="mentionableGroup")
    tag: Optional[StrictStr] = None
    __properties = ["mentionType", "mentionGroupType", "uidReference", "userReferences", "mentionableGroup", "tag"]

    @validator('mention_type')
    def mention_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('USER', 'GROUP'):
            raise ValueError("must be one of enum values ('USER', 'GROUP')")
        return value

    @validator('mention_group_type')
    def mention_group_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('JOB', 'OWNERS', 'PROVIDERS', 'GUESTS', 'WORKFLOW_STEP'):
            raise ValueError("must be one of enum values ('JOB', 'OWNERS', 'PROVIDERS', 'GUESTS', 'WORKFLOW_STEP')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MentionDto:
        """Create an instance of MentionDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of uid_reference
        if self.uid_reference:
            _dict['uidReference'] = self.uid_reference.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in user_references (list)
        _items = []
        if self.user_references:
            for _item in self.user_references:
                if _item:
                    _items.append(_item.to_dict())
            _dict['userReferences'] = _items
        # override the default output from pydantic by calling `to_dict()` of mentionable_group
        if self.mentionable_group:
            _dict['mentionableGroup'] = self.mentionable_group.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MentionDto:
        """Create an instance of MentionDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MentionDto.parse_obj(obj)

        _obj = MentionDto.parse_obj({
            "mention_type": obj.get("mentionType"),
            "mention_group_type": obj.get("mentionGroupType"),
            "uid_reference": UidReference.from_dict(obj.get("uidReference")) if obj.get("uidReference") is not None else None,
            "user_references": [MentionableUserDto.from_dict(_item) for _item in obj.get("userReferences")] if obj.get("userReferences") is not None else None,
            "mentionable_group": MentionableGroupDto.from_dict(obj.get("mentionableGroup")) if obj.get("mentionableGroup") is not None else None,
            "tag": obj.get("tag")
        })
        return _obj

