# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator

class MdSettingsDto(BaseModel):
    """
    MdSettingsDto
    """
    hard_line_breaks_segments: Optional[StrictBool] = Field(None, alias="hardLineBreaksSegments", description="Default: true")
    preserve_white_spaces: Optional[StrictBool] = Field(None, alias="preserveWhiteSpaces", description="Default: false")
    tag_regexp: Optional[StrictStr] = Field(None, alias="tagRegexp")
    custom_elements: Optional[StrictStr] = Field(None, alias="customElements")
    ignored_block_prefixes: Optional[StrictStr] = Field(None, alias="ignoredBlockPrefixes")
    flavor: Optional[StrictStr] = Field(None, description="Default: PLAIN")
    process_jekyll_front_matter: Optional[StrictBool] = Field(None, alias="processJekyllFrontMatter", description="Default: false")
    extract_code_blocks: Optional[StrictBool] = Field(None, alias="extractCodeBlocks", description="Default: true")
    not_escaped_characters: Optional[StrictStr] = Field(None, alias="notEscapedCharacters")
    exclude_code_elements: Optional[StrictBool] = Field(None, alias="excludeCodeElements", description="Default: false")
    __properties = ["hardLineBreaksSegments", "preserveWhiteSpaces", "tagRegexp", "customElements", "ignoredBlockPrefixes", "flavor", "processJekyllFrontMatter", "extractCodeBlocks", "notEscapedCharacters", "excludeCodeElements"]

    @validator('flavor')
    def flavor_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('PLAIN', 'PHP', 'GITHUB'):
            raise ValueError("must be one of enum values ('PLAIN', 'PHP', 'GITHUB')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MdSettingsDto:
        """Create an instance of MdSettingsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MdSettingsDto:
        """Create an instance of MdSettingsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MdSettingsDto.parse_obj(obj)

        _obj = MdSettingsDto.parse_obj({
            "hard_line_breaks_segments": obj.get("hardLineBreaksSegments"),
            "preserve_white_spaces": obj.get("preserveWhiteSpaces"),
            "tag_regexp": obj.get("tagRegexp"),
            "custom_elements": obj.get("customElements"),
            "ignored_block_prefixes": obj.get("ignoredBlockPrefixes"),
            "flavor": obj.get("flavor"),
            "process_jekyll_front_matter": obj.get("processJekyllFrontMatter"),
            "extract_code_blocks": obj.get("extractCodeBlocks"),
            "not_escaped_characters": obj.get("notEscapedCharacters"),
            "exclude_code_elements": obj.get("excludeCodeElements")
        })
        return _obj

