# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from phrasetms_client.models.marketo_segmentation_mapping_dto import MarketoSegmentationMappingDto
from phrasetms_client.models.variable_dto import VariableDto

class MarketoAllOf(BaseModel):
    """
    MarketoAllOf
    """
    api_key: StrictStr = Field(..., alias="apiKey")
    api_secret: StrictStr = Field(..., alias="apiSecret")
    identity_url: StrictStr = Field(..., alias="identityURL")
    connector_type: StrictStr = Field(..., alias="connectorType")
    variables: Optional[conlist(VariableDto)] = None
    segmentation_mapping: Optional[MarketoSegmentationMappingDto] = Field(None, alias="segmentationMapping")
    translate_tokens: Optional[StrictBool] = Field(None, alias="translateTokens")
    debug_mode: Optional[StrictBool] = Field(None, alias="debugMode")
    __properties = ["apiKey", "apiSecret", "identityURL", "connectorType", "variables", "segmentationMapping", "translateTokens", "debugMode"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MarketoAllOf:
        """Create an instance of MarketoAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in variables (list)
        _items = []
        if self.variables:
            for _item in self.variables:
                if _item:
                    _items.append(_item.to_dict())
            _dict['variables'] = _items
        # override the default output from pydantic by calling `to_dict()` of segmentation_mapping
        if self.segmentation_mapping:
            _dict['segmentationMapping'] = self.segmentation_mapping.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MarketoAllOf:
        """Create an instance of MarketoAllOf from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MarketoAllOf.parse_obj(obj)

        _obj = MarketoAllOf.parse_obj({
            "api_key": obj.get("apiKey"),
            "api_secret": obj.get("apiSecret"),
            "identity_url": obj.get("identityURL"),
            "connector_type": obj.get("connectorType"),
            "variables": [VariableDto.from_dict(_item) for _item in obj.get("variables")] if obj.get("variables") is not None else None,
            "segmentation_mapping": MarketoSegmentationMappingDto.from_dict(obj.get("segmentationMapping")) if obj.get("segmentationMapping") is not None else None,
            "translate_tokens": obj.get("translateTokens"),
            "debug_mode": obj.get("debugMode")
        })
        return _obj

