# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from phrasetms_client.models.edition_dto import EditionDto
from phrasetms_client.models.features_dto import FeaturesDto
from phrasetms_client.models.organization_reference import OrganizationReference
from phrasetms_client.models.user_reference import UserReference

class LoginUserDto(BaseModel):
    """
    LoginUserDto
    """
    user: Optional[UserReference] = None
    csrf_token: Optional[StrictStr] = Field(None, alias="csrfToken")
    organization: Optional[OrganizationReference] = None
    edition: Optional[EditionDto] = None
    features: Optional[FeaturesDto] = None
    __properties = ["user", "csrfToken", "organization", "edition", "features"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LoginUserDto:
        """Create an instance of LoginUserDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict['organization'] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of edition
        if self.edition:
            _dict['edition'] = self.edition.to_dict()
        # override the default output from pydantic by calling `to_dict()` of features
        if self.features:
            _dict['features'] = self.features.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LoginUserDto:
        """Create an instance of LoginUserDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LoginUserDto.parse_obj(obj)

        _obj = LoginUserDto.parse_obj({
            "user": UserReference.from_dict(obj.get("user")) if obj.get("user") is not None else None,
            "csrf_token": obj.get("csrfToken"),
            "organization": OrganizationReference.from_dict(obj.get("organization")) if obj.get("organization") is not None else None,
            "edition": EditionDto.from_dict(obj.get("edition")) if obj.get("edition") is not None else None,
            "features": FeaturesDto.from_dict(obj.get("features")) if obj.get("features") is not None else None
        })
        return _obj

