# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field
from phrasetms_client.models.toggleable_weight_dto import ToggleableWeightDto

class LocaleConventionWeightsDto(BaseModel):
    """
    LocaleConventionWeightsDto
    """
    locale_convention: Optional[ToggleableWeightDto] = Field(None, alias="localeConvention")
    address_format: Optional[ToggleableWeightDto] = Field(None, alias="addressFormat")
    date_format: Optional[ToggleableWeightDto] = Field(None, alias="dateFormat")
    currency_format: Optional[ToggleableWeightDto] = Field(None, alias="currencyFormat")
    measurement_format: Optional[ToggleableWeightDto] = Field(None, alias="measurementFormat")
    shortcut_key: Optional[ToggleableWeightDto] = Field(None, alias="shortcutKey")
    telephone_format: Optional[ToggleableWeightDto] = Field(None, alias="telephoneFormat")
    __properties = ["localeConvention", "addressFormat", "dateFormat", "currencyFormat", "measurementFormat", "shortcutKey", "telephoneFormat"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LocaleConventionWeightsDto:
        """Create an instance of LocaleConventionWeightsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of locale_convention
        if self.locale_convention:
            _dict['localeConvention'] = self.locale_convention.to_dict()
        # override the default output from pydantic by calling `to_dict()` of address_format
        if self.address_format:
            _dict['addressFormat'] = self.address_format.to_dict()
        # override the default output from pydantic by calling `to_dict()` of date_format
        if self.date_format:
            _dict['dateFormat'] = self.date_format.to_dict()
        # override the default output from pydantic by calling `to_dict()` of currency_format
        if self.currency_format:
            _dict['currencyFormat'] = self.currency_format.to_dict()
        # override the default output from pydantic by calling `to_dict()` of measurement_format
        if self.measurement_format:
            _dict['measurementFormat'] = self.measurement_format.to_dict()
        # override the default output from pydantic by calling `to_dict()` of shortcut_key
        if self.shortcut_key:
            _dict['shortcutKey'] = self.shortcut_key.to_dict()
        # override the default output from pydantic by calling `to_dict()` of telephone_format
        if self.telephone_format:
            _dict['telephoneFormat'] = self.telephone_format.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LocaleConventionWeightsDto:
        """Create an instance of LocaleConventionWeightsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LocaleConventionWeightsDto.parse_obj(obj)

        _obj = LocaleConventionWeightsDto.parse_obj({
            "locale_convention": ToggleableWeightDto.from_dict(obj.get("localeConvention")) if obj.get("localeConvention") is not None else None,
            "address_format": ToggleableWeightDto.from_dict(obj.get("addressFormat")) if obj.get("addressFormat") is not None else None,
            "date_format": ToggleableWeightDto.from_dict(obj.get("dateFormat")) if obj.get("dateFormat") is not None else None,
            "currency_format": ToggleableWeightDto.from_dict(obj.get("currencyFormat")) if obj.get("currencyFormat") is not None else None,
            "measurement_format": ToggleableWeightDto.from_dict(obj.get("measurementFormat")) if obj.get("measurementFormat") is not None else None,
            "shortcut_key": ToggleableWeightDto.from_dict(obj.get("shortcutKey")) if obj.get("shortcutKey") is not None else None,
            "telephone_format": ToggleableWeightDto.from_dict(obj.get("telephoneFormat")) if obj.get("telephoneFormat") is not None else None
        })
        return _obj

