# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from phrasetms_client.models.uid_reference import UidReference


class LINGUISTEDITAllOf(BaseModel):
    """
    LINGUISTEDITAllOf
    """

    edit_all_terms_in_tb: Optional[StrictBool] = Field(
        None,
        alias="editAllTermsInTB",
        description="Edit all terms in TB. Default: false",
    )
    edit_translations_in_tm: Optional[StrictBool] = Field(
        None,
        alias="editTranslationsInTM",
        description="Edit translations in TM. Default: false",
    )
    enable_mt: Optional[StrictBool] = Field(
        None, alias="enableMT", description="Enable MT. Default: true"
    )
    may_reject_jobs: Optional[StrictBool] = Field(
        None, alias="mayRejectJobs", description="Reject jobs. Default: false"
    )
    source_locales: Optional[conlist(StrictStr)] = Field(None, alias="sourceLocales")
    target_locales: Optional[conlist(StrictStr)] = Field(None, alias="targetLocales")
    workflow_steps: Optional[conlist(UidReference)] = Field(None, alias="workflowSteps")
    clients: Optional[conlist(UidReference)] = None
    domains: Optional[conlist(UidReference)] = None
    sub_domains: Optional[conlist(UidReference)] = Field(None, alias="subDomains")
    net_rate_scheme: Optional[UidReference] = Field(None, alias="netRateScheme")
    translation_price_list: Optional[UidReference] = Field(
        None, alias="translationPriceList"
    )
    __properties = [
        "editAllTermsInTB",
        "editTranslationsInTM",
        "enableMT",
        "mayRejectJobs",
        "sourceLocales",
        "targetLocales",
        "workflowSteps",
        "clients",
        "domains",
        "subDomains",
        "netRateScheme",
        "translationPriceList",
    ]

    class Config:
        """Pydantic configuration"""

        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LINGUISTEDITAllOf:
        """Create an instance of LINGUISTEDITAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in workflow_steps (list)
        _items = []
        if self.workflow_steps:
            for _item in self.workflow_steps:
                if _item:
                    _items.append(_item.to_dict())
            _dict["workflowSteps"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in clients (list)
        _items = []
        if self.clients:
            for _item in self.clients:
                if _item:
                    _items.append(_item.to_dict())
            _dict["clients"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in domains (list)
        _items = []
        if self.domains:
            for _item in self.domains:
                if _item:
                    _items.append(_item.to_dict())
            _dict["domains"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in sub_domains (list)
        _items = []
        if self.sub_domains:
            for _item in self.sub_domains:
                if _item:
                    _items.append(_item.to_dict())
            _dict["subDomains"] = _items
        # override the default output from pydantic by calling `to_dict()` of net_rate_scheme
        if self.net_rate_scheme:
            _dict["netRateScheme"] = self.net_rate_scheme.to_dict()
        # override the default output from pydantic by calling `to_dict()` of translation_price_list
        if self.translation_price_list:
            _dict["translationPriceList"] = self.translation_price_list.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LINGUISTEDITAllOf:
        """Create an instance of LINGUISTEDITAllOf from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LINGUISTEDITAllOf.parse_obj(obj)

        _obj = LINGUISTEDITAllOf.parse_obj(
            {
                "edit_all_terms_in_tb": obj.get("editAllTermsInTB"),
                "edit_translations_in_tm": obj.get("editTranslationsInTM"),
                "enable_mt": obj.get("enableMT"),
                "may_reject_jobs": obj.get("mayRejectJobs"),
                "source_locales": obj.get("sourceLocales"),
                "target_locales": obj.get("targetLocales"),
                "workflow_steps": [
                    UidReference.from_dict(_item) for _item in obj.get("workflowSteps")
                ]
                if obj.get("workflowSteps") is not None
                else None,
                "clients": [
                    UidReference.from_dict(_item) for _item in obj.get("clients")
                ]
                if obj.get("clients") is not None
                else None,
                "domains": [
                    UidReference.from_dict(_item) for _item in obj.get("domains")
                ]
                if obj.get("domains") is not None
                else None,
                "sub_domains": [
                    UidReference.from_dict(_item) for _item in obj.get("subDomains")
                ]
                if obj.get("subDomains") is not None
                else None,
                "net_rate_scheme": UidReference.from_dict(obj.get("netRateScheme"))
                if obj.get("netRateScheme") is not None
                else None,
                "translation_price_list": UidReference.from_dict(
                    obj.get("translationPriceList")
                )
                if obj.get("translationPriceList") is not None
                else None,
            }
        )
        return _obj
