# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel
from phrasetms_client.models.abstract_project_dto import AbstractProjectDto
from phrasetms_client.models.domain_reference import DomainReference
from phrasetms_client.models.mt_settings_per_language_reference import MTSettingsPerLanguageReference
from phrasetms_client.models.reference_file_reference import ReferenceFileReference
from phrasetms_client.models.sub_domain_reference import SubDomainReference
from phrasetms_client.models.user_reference import UserReference

class Linguist(AbstractProjectDto):
    """
    Linguist
    """
    __properties = ["uid", "internalId", "id", "name", "dateCreated", "domain", "subDomain", "owner", "sourceLang", "targetLangs", "references", "mtSettingsPerLanguageList", "userRole"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Linguist:
        """Create an instance of Linguist from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of domain
        if self.domain:
            _dict['domain'] = self.domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sub_domain
        if self.sub_domain:
            _dict['subDomain'] = self.sub_domain.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in references (list)
        _items = []
        if self.references:
            for _item in self.references:
                if _item:
                    _items.append(_item.to_dict())
            _dict['references'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in mt_settings_per_language_list (list)
        _items = []
        if self.mt_settings_per_language_list:
            for _item in self.mt_settings_per_language_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict['mtSettingsPerLanguageList'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Linguist:
        """Create an instance of Linguist from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Linguist.parse_obj(obj)

        _obj = Linguist.parse_obj({
            "uid": obj.get("uid"),
            "internal_id": obj.get("internalId"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "date_created": obj.get("dateCreated"),
            "domain": DomainReference.from_dict(obj.get("domain")) if obj.get("domain") is not None else None,
            "sub_domain": SubDomainReference.from_dict(obj.get("subDomain")) if obj.get("subDomain") is not None else None,
            "owner": UserReference.from_dict(obj.get("owner")) if obj.get("owner") is not None else None,
            "source_lang": obj.get("sourceLang"),
            "target_langs": obj.get("targetLangs"),
            "references": [ReferenceFileReference.from_dict(_item) for _item in obj.get("references")] if obj.get("references") is not None else None,
            "mt_settings_per_language_list": [MTSettingsPerLanguageReference.from_dict(_item) for _item in obj.get("mtSettingsPerLanguageList")] if obj.get("mtSettingsPerLanguageList") is not None else None,
            "user_role": obj.get("userRole")
        })
        return _obj

