# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class JsonSettingsDto(BaseModel):
    """
    JsonSettingsDto
    """
    tag_regexp: Optional[StrictStr] = Field(None, alias="tagRegexp")
    html_sub_filter: Optional[StrictBool] = Field(None, alias="htmlSubFilter", description="Default: true")
    icu_sub_filter: Optional[StrictBool] = Field(None, alias="icuSubFilter", description="Default: false")
    exclude_key_regexp: Optional[StrictStr] = Field(None, alias="excludeKeyRegexp")
    include_key_regexp: Optional[StrictStr] = Field(None, alias="includeKeyRegexp")
    context_note_path: Optional[StrictStr] = Field(None, alias="contextNotePath")
    max_len_path: Optional[StrictStr] = Field(None, alias="maxLenPath")
    context_key_path: Optional[StrictStr] = Field(None, alias="contextKeyPath")
    __properties = ["tagRegexp", "htmlSubFilter", "icuSubFilter", "excludeKeyRegexp", "includeKeyRegexp", "contextNotePath", "maxLenPath", "contextKeyPath"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JsonSettingsDto:
        """Create an instance of JsonSettingsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JsonSettingsDto:
        """Create an instance of JsonSettingsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return JsonSettingsDto.parse_obj(obj)

        _obj = JsonSettingsDto.parse_obj({
            "tag_regexp": obj.get("tagRegexp"),
            "html_sub_filter": obj.get("htmlSubFilter"),
            "icu_sub_filter": obj.get("icuSubFilter"),
            "exclude_key_regexp": obj.get("excludeKeyRegexp"),
            "include_key_regexp": obj.get("includeKeyRegexp"),
            "context_note_path": obj.get("contextNotePath"),
            "max_len_path": obj.get("maxLenPath"),
            "context_key_path": obj.get("contextKeyPath")
        })
        return _obj

