# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, validator
from phrasetms_client.models.project_workflow_step_dto_v2 import ProjectWorkflowStepDtoV2

class JobRoleDto(BaseModel):
    """
    JobRoleDto
    """
    type: StrictStr = Field(...)
    workflow_step: Optional[ProjectWorkflowStepDtoV2] = Field(None, alias="workflowStep")
    organization_type: Optional[StrictStr] = Field(None, alias="organizationType", description="not null only for shared projects")
    __properties = ["type", "workflowStep", "organizationType"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('PROJECT_OWNER', 'JOB_OWNER', 'PROVIDER', 'GUEST'):
            raise ValueError("must be one of enum values ('PROJECT_OWNER', 'JOB_OWNER', 'PROVIDER', 'GUEST')")
        return value

    @validator('organization_type')
    def organization_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('VENDOR', 'BUYER'):
            raise ValueError("must be one of enum values ('VENDOR', 'BUYER')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JobRoleDto:
        """Create an instance of JobRoleDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of workflow_step
        if self.workflow_step:
            _dict['workflowStep'] = self.workflow_step.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JobRoleDto:
        """Create an instance of JobRoleDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return JobRoleDto.parse_obj(obj)

        _obj = JobRoleDto.parse_obj({
            "type": obj.get("type"),
            "workflow_step": ProjectWorkflowStepDtoV2.from_dict(obj.get("workflowStep")) if obj.get("workflowStep") is not None else None,
            "organization_type": obj.get("organizationType")
        })
        return _obj

