# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, validator
from phrasetms_client.models.import_status_dto_v2 import ImportStatusDtoV2
from phrasetms_client.models.project_workflow_step_reference import ProjectWorkflowStepReference
from phrasetms_client.models.provider_reference import ProviderReference
from phrasetms_client.models.user_reference import UserReference

class JobPartReferenceV2(BaseModel):
    """
    JobPartReferenceV2
    """
    uid: Optional[StrictStr] = None
    inner_id: Optional[StrictStr] = Field(None, alias="innerId", description="InnerId is a sequential number of a job in a project.             Jobs created from the same file share the same innerId across workflow steps")
    status: Optional[StrictStr] = None
    providers: Optional[conlist(ProviderReference)] = None
    target_lang: Optional[StrictStr] = Field(None, alias="targetLang")
    workflow_step: Optional[ProjectWorkflowStepReference] = Field(None, alias="workflowStep")
    filename: Optional[StrictStr] = None
    original_file_directory: Optional[StrictStr] = Field(None, alias="originalFileDirectory")
    date_due: Optional[datetime] = Field(None, alias="dateDue")
    date_created: Optional[datetime] = Field(None, alias="dateCreated")
    import_status: Optional[ImportStatusDtoV2] = Field(None, alias="importStatus")
    continuous: Optional[StrictBool] = None
    source_file_uid: Optional[StrictStr] = Field(None, alias="sourceFileUid")
    split: Optional[StrictBool] = None
    server_task_id: Optional[StrictStr] = Field(None, alias="serverTaskId")
    owner: Optional[UserReference] = None
    imported: Optional[StrictBool] = Field(None, description="Default: false")
    __properties = ["uid", "innerId", "status", "providers", "targetLang", "workflowStep", "filename", "originalFileDirectory", "dateDue", "dateCreated", "importStatus", "continuous", "sourceFileUid", "split", "serverTaskId", "owner", "imported"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('NEW', 'ACCEPTED', 'DECLINED', 'REJECTED', 'DELIVERED', 'EMAILED', 'COMPLETED', 'CANCELLED'):
            raise ValueError("must be one of enum values ('NEW', 'ACCEPTED', 'DECLINED', 'REJECTED', 'DELIVERED', 'EMAILED', 'COMPLETED', 'CANCELLED')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JobPartReferenceV2:
        """Create an instance of JobPartReferenceV2 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in providers (list)
        _items = []
        if self.providers:
            for _item in self.providers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['providers'] = _items
        # override the default output from pydantic by calling `to_dict()` of workflow_step
        if self.workflow_step:
            _dict['workflowStep'] = self.workflow_step.to_dict()
        # override the default output from pydantic by calling `to_dict()` of import_status
        if self.import_status:
            _dict['importStatus'] = self.import_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JobPartReferenceV2:
        """Create an instance of JobPartReferenceV2 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return JobPartReferenceV2.parse_obj(obj)

        _obj = JobPartReferenceV2.parse_obj({
            "uid": obj.get("uid"),
            "inner_id": obj.get("innerId"),
            "status": obj.get("status"),
            "providers": [ProviderReference.from_dict(_item) for _item in obj.get("providers")] if obj.get("providers") is not None else None,
            "target_lang": obj.get("targetLang"),
            "workflow_step": ProjectWorkflowStepReference.from_dict(obj.get("workflowStep")) if obj.get("workflowStep") is not None else None,
            "filename": obj.get("filename"),
            "original_file_directory": obj.get("originalFileDirectory"),
            "date_due": obj.get("dateDue"),
            "date_created": obj.get("dateCreated"),
            "import_status": ImportStatusDtoV2.from_dict(obj.get("importStatus")) if obj.get("importStatus") is not None else None,
            "continuous": obj.get("continuous"),
            "source_file_uid": obj.get("sourceFileUid"),
            "split": obj.get("split"),
            "server_task_id": obj.get("serverTaskId"),
            "owner": UserReference.from_dict(obj.get("owner")) if obj.get("owner") is not None else None,
            "imported": obj.get("imported")
        })
        return _obj

