# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist, validator
from phrasetms_client.models.provider_reference import ProviderReference
from phrasetms_client.models.workflow_step_reference import WorkflowStepReference

class JobPartReference(BaseModel):
    """
    JobPartReference
    """
    uid: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    providers: Optional[conlist(ProviderReference)] = None
    target_lang: Optional[StrictStr] = Field(None, alias="targetLang")
    workflow_level: Optional[StrictInt] = Field(None, alias="workflowLevel")
    workflow_step: Optional[WorkflowStepReference] = Field(None, alias="workflowStep")
    filename: Optional[StrictStr] = None
    date_due: Optional[datetime] = Field(None, alias="dateDue")
    date_created: Optional[datetime] = Field(None, alias="dateCreated")
    update_source_date: Optional[datetime] = Field(None, alias="updateSourceDate")
    imported: Optional[StrictBool] = None
    job_assigned_email_template: Optional[Dict[str, Any]] = Field(None, alias="jobAssignedEmailTemplate")
    notification_interval_in_minutes: Optional[StrictInt] = Field(None, alias="notificationIntervalInMinutes")
    continuous: Optional[StrictBool] = None
    source_file_uid: Optional[StrictStr] = Field(None, alias="sourceFileUid")
    __properties = ["uid", "status", "providers", "targetLang", "workflowLevel", "workflowStep", "filename", "dateDue", "dateCreated", "updateSourceDate", "imported", "jobAssignedEmailTemplate", "notificationIntervalInMinutes", "continuous", "sourceFileUid"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('NEW', 'ACCEPTED', 'DECLINED', 'REJECTED', 'DELIVERED', 'EMAILED', 'COMPLETED', 'CANCELLED'):
            raise ValueError("must be one of enum values ('NEW', 'ACCEPTED', 'DECLINED', 'REJECTED', 'DELIVERED', 'EMAILED', 'COMPLETED', 'CANCELLED')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JobPartReference:
        """Create an instance of JobPartReference from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in providers (list)
        _items = []
        if self.providers:
            for _item in self.providers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['providers'] = _items
        # override the default output from pydantic by calling `to_dict()` of workflow_step
        if self.workflow_step:
            _dict['workflowStep'] = self.workflow_step.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JobPartReference:
        """Create an instance of JobPartReference from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return JobPartReference.parse_obj(obj)

        _obj = JobPartReference.parse_obj({
            "uid": obj.get("uid"),
            "status": obj.get("status"),
            "providers": [ProviderReference.from_dict(_item) for _item in obj.get("providers")] if obj.get("providers") is not None else None,
            "target_lang": obj.get("targetLang"),
            "workflow_level": obj.get("workflowLevel"),
            "workflow_step": WorkflowStepReference.from_dict(obj.get("workflowStep")) if obj.get("workflowStep") is not None else None,
            "filename": obj.get("filename"),
            "date_due": obj.get("dateDue"),
            "date_created": obj.get("dateCreated"),
            "update_source_date": obj.get("updateSourceDate"),
            "imported": obj.get("imported"),
            "job_assigned_email_template": obj.get("jobAssignedEmailTemplate"),
            "notification_interval_in_minutes": obj.get("notificationIntervalInMinutes"),
            "continuous": obj.get("continuous"),
            "source_file_uid": obj.get("sourceFileUid")
        })
        return _obj

