# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist
from phrasetms_client.models.provider_reference import ProviderReference
from phrasetms_client.models.uid_reference import UidReference

class JobPartReadyDeleteTranslationFilterDto(BaseModel):
    """
    JobPartReadyDeleteTranslationFilterDto
    """
    filename: Optional[StrictStr] = None
    statuses: Optional[conlist(StrictStr)] = None
    target_lang: Optional[StrictStr] = Field(None, alias="targetLang")
    provider: Optional[ProviderReference] = None
    owner: Optional[UidReference] = None
    date_due: Optional[datetime] = Field(None, alias="dateDue")
    due_in_hours: Optional[StrictInt] = Field(None, alias="dueInHours")
    overdue: Optional[StrictBool] = None
    __properties = ["filename", "statuses", "targetLang", "provider", "owner", "dateDue", "dueInHours", "overdue"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JobPartReadyDeleteTranslationFilterDto:
        """Create an instance of JobPartReadyDeleteTranslationFilterDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of provider
        if self.provider:
            _dict['provider'] = self.provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JobPartReadyDeleteTranslationFilterDto:
        """Create an instance of JobPartReadyDeleteTranslationFilterDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return JobPartReadyDeleteTranslationFilterDto.parse_obj(obj)

        _obj = JobPartReadyDeleteTranslationFilterDto.parse_obj({
            "filename": obj.get("filename"),
            "statuses": obj.get("statuses"),
            "target_lang": obj.get("targetLang"),
            "provider": ProviderReference.from_dict(obj.get("provider")) if obj.get("provider") is not None else None,
            "owner": UidReference.from_dict(obj.get("owner")) if obj.get("owner") is not None else None,
            "date_due": obj.get("dateDue"),
            "due_in_hours": obj.get("dueInHours"),
            "overdue": obj.get("overdue")
        })
        return _obj

