# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, conlist
from phrasetms_client.models.job_part_ready_delete_translation_filter_dto import JobPartReadyDeleteTranslationFilterDto
from phrasetms_client.models.translation_segments_reference_v2 import TranslationSegmentsReferenceV2
from phrasetms_client.models.uid_reference import UidReference

class JobPartReadyDeleteTranslationDto(BaseModel):
    """
    JobPartReadyDeleteTranslationDto
    """
    jobs: Optional[conlist(UidReference, max_items=100, min_items=1)] = None
    delete_settings: Optional[TranslationSegmentsReferenceV2] = Field(None, alias="deleteSettings")
    for_all_jobs: Optional[StrictBool] = Field(None, alias="forAllJobs", description="Set true if you want to delete translations for all jobs from project from specific workflow step.                Default: false")
    workflow_level: Optional[StrictInt] = Field(None, alias="workflowLevel", description="Specifies workflow level for all jobs")
    filter: Optional[JobPartReadyDeleteTranslationFilterDto] = None
    get_parts: Optional[Dict[str, Any]] = Field(None, alias="getParts")
    __properties = ["jobs", "deleteSettings", "forAllJobs", "workflowLevel", "filter", "getParts"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JobPartReadyDeleteTranslationDto:
        """Create an instance of JobPartReadyDeleteTranslationDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in jobs (list)
        _items = []
        if self.jobs:
            for _item in self.jobs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['jobs'] = _items
        # override the default output from pydantic by calling `to_dict()` of delete_settings
        if self.delete_settings:
            _dict['deleteSettings'] = self.delete_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of filter
        if self.filter:
            _dict['filter'] = self.filter.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JobPartReadyDeleteTranslationDto:
        """Create an instance of JobPartReadyDeleteTranslationDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return JobPartReadyDeleteTranslationDto.parse_obj(obj)

        _obj = JobPartReadyDeleteTranslationDto.parse_obj({
            "jobs": [UidReference.from_dict(_item) for _item in obj.get("jobs")] if obj.get("jobs") is not None else None,
            "delete_settings": TranslationSegmentsReferenceV2.from_dict(obj.get("deleteSettings")) if obj.get("deleteSettings") is not None else None,
            "for_all_jobs": obj.get("forAllJobs"),
            "workflow_level": obj.get("workflowLevel"),
            "filter": JobPartReadyDeleteTranslationFilterDto.from_dict(obj.get("filter")) if obj.get("filter") is not None else None,
            "get_parts": obj.get("getParts")
        })
        return _obj

