# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist, validator
from phrasetms_client.models.continuous_job_info_dto import ContinuousJobInfoDto
from phrasetms_client.models.import_status_dto import ImportStatusDto
from phrasetms_client.models.job_reference import JobReference
from phrasetms_client.models.project_reference import ProjectReference
from phrasetms_client.models.project_workflow_step_reference import ProjectWorkflowStepReference
from phrasetms_client.models.provider_reference import ProviderReference

class JobPartExtendedDto(BaseModel):
    """
    JobPartExtendedDto
    """
    uid: Optional[StrictStr] = None
    inner_id: Optional[StrictStr] = Field(None, alias="innerId", description="InnerId is a sequential number of a job in a project. Jobs created from the same file share the same innerId across workflow steps.")
    status: Optional[StrictStr] = None
    providers: Optional[conlist(ProviderReference)] = None
    source_lang: Optional[StrictStr] = Field(None, alias="sourceLang")
    target_lang: Optional[StrictStr] = Field(None, alias="targetLang")
    workflow_level: Optional[StrictInt] = Field(None, alias="workflowLevel")
    workflow_step: Optional[ProjectWorkflowStepReference] = Field(None, alias="workflowStep")
    filename: Optional[StrictStr] = None
    date_due: Optional[datetime] = Field(None, alias="dateDue")
    words_count: Optional[StrictInt] = Field(None, alias="wordsCount")
    begin_index: Optional[StrictInt] = Field(None, alias="beginIndex")
    end_index: Optional[StrictInt] = Field(None, alias="endIndex")
    is_parent_job_split: Optional[StrictBool] = Field(None, alias="isParentJobSplit")
    update_source_date: Optional[datetime] = Field(None, alias="updateSourceDate")
    update_target_date: Optional[datetime] = Field(None, alias="updateTargetDate")
    date_created: Optional[datetime] = Field(None, alias="dateCreated")
    job_reference: Optional[JobReference] = Field(None, alias="jobReference")
    project: Optional[ProjectReference] = None
    last_workflow_level: Optional[StrictInt] = Field(None, alias="lastWorkflowLevel")
    work_unit: Optional[Dict[str, Any]] = Field(None, alias="workUnit")
    import_status: Optional[ImportStatusDto] = Field(None, alias="importStatus")
    imported: Optional[StrictBool] = None
    continuous: Optional[StrictBool] = None
    continuous_job_info: Optional[ContinuousJobInfoDto] = Field(None, alias="continuousJobInfo")
    original_file_directory: Optional[StrictStr] = Field(None, alias="originalFileDirectory")
    __properties = ["uid", "innerId", "status", "providers", "sourceLang", "targetLang", "workflowLevel", "workflowStep", "filename", "dateDue", "wordsCount", "beginIndex", "endIndex", "isParentJobSplit", "updateSourceDate", "updateTargetDate", "dateCreated", "jobReference", "project", "lastWorkflowLevel", "workUnit", "importStatus", "imported", "continuous", "continuousJobInfo", "originalFileDirectory"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('NEW', 'ACCEPTED', 'DECLINED', 'REJECTED', 'DELIVERED', 'EMAILED', 'COMPLETED', 'CANCELLED'):
            raise ValueError("must be one of enum values ('NEW', 'ACCEPTED', 'DECLINED', 'REJECTED', 'DELIVERED', 'EMAILED', 'COMPLETED', 'CANCELLED')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JobPartExtendedDto:
        """Create an instance of JobPartExtendedDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in providers (list)
        _items = []
        if self.providers:
            for _item in self.providers:
                if _item:
                    _items.append(_item.to_dict())
            _dict['providers'] = _items
        # override the default output from pydantic by calling `to_dict()` of workflow_step
        if self.workflow_step:
            _dict['workflowStep'] = self.workflow_step.to_dict()
        # override the default output from pydantic by calling `to_dict()` of job_reference
        if self.job_reference:
            _dict['jobReference'] = self.job_reference.to_dict()
        # override the default output from pydantic by calling `to_dict()` of project
        if self.project:
            _dict['project'] = self.project.to_dict()
        # override the default output from pydantic by calling `to_dict()` of import_status
        if self.import_status:
            _dict['importStatus'] = self.import_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of continuous_job_info
        if self.continuous_job_info:
            _dict['continuousJobInfo'] = self.continuous_job_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JobPartExtendedDto:
        """Create an instance of JobPartExtendedDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return JobPartExtendedDto.parse_obj(obj)

        _obj = JobPartExtendedDto.parse_obj({
            "uid": obj.get("uid"),
            "inner_id": obj.get("innerId"),
            "status": obj.get("status"),
            "providers": [ProviderReference.from_dict(_item) for _item in obj.get("providers")] if obj.get("providers") is not None else None,
            "source_lang": obj.get("sourceLang"),
            "target_lang": obj.get("targetLang"),
            "workflow_level": obj.get("workflowLevel"),
            "workflow_step": ProjectWorkflowStepReference.from_dict(obj.get("workflowStep")) if obj.get("workflowStep") is not None else None,
            "filename": obj.get("filename"),
            "date_due": obj.get("dateDue"),
            "words_count": obj.get("wordsCount"),
            "begin_index": obj.get("beginIndex"),
            "end_index": obj.get("endIndex"),
            "is_parent_job_split": obj.get("isParentJobSplit"),
            "update_source_date": obj.get("updateSourceDate"),
            "update_target_date": obj.get("updateTargetDate"),
            "date_created": obj.get("dateCreated"),
            "job_reference": JobReference.from_dict(obj.get("jobReference")) if obj.get("jobReference") is not None else None,
            "project": ProjectReference.from_dict(obj.get("project")) if obj.get("project") is not None else None,
            "last_workflow_level": obj.get("lastWorkflowLevel"),
            "work_unit": obj.get("workUnit"),
            "import_status": ImportStatusDto.from_dict(obj.get("importStatus")) if obj.get("importStatus") is not None else None,
            "imported": obj.get("imported"),
            "continuous": obj.get("continuous"),
            "continuous_job_info": ContinuousJobInfoDto.from_dict(obj.get("continuousJobInfo")) if obj.get("continuousJobInfo") is not None else None,
            "original_file_directory": obj.get("originalFileDirectory")
        })
        return _obj

