# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool

class JobMachineTranslationSettingsDto(BaseModel):
    """
    Machine translation related settings
    """
    use_machine_translation: Optional[StrictBool] = Field(None, alias="useMachineTranslation", description="Pre-translate from machine translation. Default: true")
    lock100_percent_matches: Optional[StrictBool] = Field(None, alias="lock100PercentMatches", description="Lock section: 100% machine translation matches. Default: false")
    confirm100_percent_matches: Optional[StrictBool] = Field(None, alias="confirm100PercentMatches", description="Set segment status to confirmed for: 100% translation machine matches. Default: false")
    use_alt_trans_only: Optional[StrictBool] = Field(None, alias="useAltTransOnly", description="Do not put machine translations to target and use alt-trans fields (alt-trans in mxlf). Default: false")
    __properties = ["useMachineTranslation", "lock100PercentMatches", "confirm100PercentMatches", "useAltTransOnly"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JobMachineTranslationSettingsDto:
        """Create an instance of JobMachineTranslationSettingsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JobMachineTranslationSettingsDto:
        """Create an instance of JobMachineTranslationSettingsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return JobMachineTranslationSettingsDto.parse_obj(obj)

        _obj = JobMachineTranslationSettingsDto.parse_obj({
            "use_machine_translation": obj.get("useMachineTranslation"),
            "lock100_percent_matches": obj.get("lock100PercentMatches"),
            "confirm100_percent_matches": obj.get("confirm100PercentMatches"),
            "use_alt_trans_only": obj.get("useAltTransOnly")
        })
        return _obj

