# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, constr
from phrasetms_client.models.job_create_remote_file_dto import JobCreateRemoteFileDto
from phrasetms_client.models.notify_provider_dto import NotifyProviderDto
from phrasetms_client.models.providers_per_language import ProvidersPerLanguage
from phrasetms_client.models.uid_reference import UidReference
from phrasetms_client.models.workflow_step_configuration import WorkflowStepConfiguration
from phrasetms_client.utils import DateTimeEncoder

class JobCreateRequestDto(BaseModel):
    """
    JobCreateRequestDto
    """
    target_langs: conlist(StrictStr) = Field(..., alias="targetLangs")
    due: Optional[datetime] = Field(None, description="only use for projects without workflows; otherwise specify in the workflowSettings object. Use ISO 8601 date format.")
    workflow_settings: Optional[conlist(WorkflowStepConfiguration)] = Field(None, alias="workflowSettings")
    assignments: Optional[conlist(ProvidersPerLanguage)] = Field(None, description="only use for projects without workflows; otherwise specify in the workflowSettings object")
    import_settings: Optional[UidReference] = Field(None, alias="importSettings")
    use_project_file_import_settings: Optional[StrictBool] = Field(None, alias="useProjectFileImportSettings", description="Default: false")
    pre_translate: Optional[StrictBool] = Field(None, alias="preTranslate")
    notify_provider: Optional[NotifyProviderDto] = Field(None, alias="notifyProvider")
    callback_url: Optional[StrictStr] = Field(None, alias="callbackUrl")
    path: Optional[constr(strict=True, max_length=255, min_length=0)] = None
    remote_file: Optional[JobCreateRemoteFileDto] = Field(None, alias="remoteFile")
    __properties = ["targetLangs", "due", "workflowSettings", "assignments", "importSettings", "useProjectFileImportSettings", "preTranslate", "notifyProvider", "callbackUrl", "path", "remoteFile"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(), cls=DateTimeEncoder)

    @classmethod
    def from_json(cls, json_str: str) -> JobCreateRequestDto:
        """Create an instance of JobCreateRequestDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in workflow_settings (list)
        _items = []
        if self.workflow_settings:
            for _item in self.workflow_settings:
                if _item:
                    _items.append(_item.to_dict())
            _dict['workflowSettings'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in assignments (list)
        _items = []
        if self.assignments:
            for _item in self.assignments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['assignments'] = _items
        # override the default output from pydantic by calling `to_dict()` of import_settings
        if self.import_settings:
            _dict['importSettings'] = self.import_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of notify_provider
        if self.notify_provider:
            _dict['notifyProvider'] = self.notify_provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of remote_file
        if self.remote_file:
            _dict['remoteFile'] = self.remote_file.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JobCreateRequestDto:
        """Create an instance of JobCreateRequestDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return JobCreateRequestDto.parse_obj(obj)

        _obj = JobCreateRequestDto.parse_obj({
            "target_langs": obj.get("targetLangs"),
            "due": obj.get("due"),
            "workflow_settings": [WorkflowStepConfiguration.from_dict(_item) for _item in obj.get("workflowSettings")] if obj.get("workflowSettings") is not None else None,
            "assignments": [ProvidersPerLanguage.from_dict(_item) for _item in obj.get("assignments")] if obj.get("assignments") is not None else None,
            "import_settings": UidReference.from_dict(obj.get("importSettings")) if obj.get("importSettings") is not None else None,
            "use_project_file_import_settings": obj.get("useProjectFileImportSettings"),
            "pre_translate": obj.get("preTranslate"),
            "notify_provider": NotifyProviderDto.from_dict(obj.get("notifyProvider")) if obj.get("notifyProvider") is not None else None,
            "callback_url": obj.get("callbackUrl"),
            "path": obj.get("path"),
            "remote_file": JobCreateRemoteFileDto.from_dict(obj.get("remoteFile")) if obj.get("remoteFile") is not None else None
        })
        return _obj

