# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class IdmlSettingsDto(BaseModel):
    """
    IdmlSettingsDto
    """
    extract_notes: Optional[StrictBool] = Field(None, alias="extractNotes", description="Default: false")
    simplify_codes: Optional[StrictBool] = Field(None, alias="simplifyCodes", description="Default: true")
    extract_master_spreads: Optional[StrictBool] = Field(None, alias="extractMasterSpreads", description="Default: true")
    extract_locked_layers: Optional[StrictBool] = Field(None, alias="extractLockedLayers", description="Default: true")
    extract_invisible_layers: Optional[StrictBool] = Field(None, alias="extractInvisibleLayers", description="Default: false")
    extract_hidden_conditional_text: Optional[StrictBool] = Field(None, alias="extractHiddenConditionalText", description="Default: false")
    extract_hyperlinks: Optional[StrictBool] = Field(None, alias="extractHyperlinks", description="Default: false")
    keep_kerning: Optional[StrictBool] = Field(None, alias="keepKerning", description="Default: false")
    keep_tracking: Optional[StrictBool] = Field(None, alias="keepTracking", description="Default: false")
    target_font: Optional[StrictStr] = Field(None, alias="targetFont")
    replace_font: Optional[StrictBool] = Field(None, alias="replaceFont", description="Default: true")
    remove_xml_elements: Optional[StrictBool] = Field(None, alias="removeXmlElements", description="Default: false")
    tag_regexp: Optional[StrictStr] = Field(None, alias="tagRegexp")
    extract_cross_reference_formats: Optional[StrictBool] = Field(None, alias="extractCrossReferenceFormats", description="Default: true")
    extract_variables: Optional[StrictBool] = Field(None, alias="extractVariables", description="Default: true")
    __properties = ["extractNotes", "simplifyCodes", "extractMasterSpreads", "extractLockedLayers", "extractInvisibleLayers", "extractHiddenConditionalText", "extractHyperlinks", "keepKerning", "keepTracking", "targetFont", "replaceFont", "removeXmlElements", "tagRegexp", "extractCrossReferenceFormats", "extractVariables"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> IdmlSettingsDto:
        """Create an instance of IdmlSettingsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> IdmlSettingsDto:
        """Create an instance of IdmlSettingsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return IdmlSettingsDto.parse_obj(obj)

        _obj = IdmlSettingsDto.parse_obj({
            "extract_notes": obj.get("extractNotes"),
            "simplify_codes": obj.get("simplifyCodes"),
            "extract_master_spreads": obj.get("extractMasterSpreads"),
            "extract_locked_layers": obj.get("extractLockedLayers"),
            "extract_invisible_layers": obj.get("extractInvisibleLayers"),
            "extract_hidden_conditional_text": obj.get("extractHiddenConditionalText"),
            "extract_hyperlinks": obj.get("extractHyperlinks"),
            "keep_kerning": obj.get("keepKerning"),
            "keep_tracking": obj.get("keepTracking"),
            "target_font": obj.get("targetFont"),
            "replace_font": obj.get("replaceFont"),
            "remove_xml_elements": obj.get("removeXmlElements"),
            "tag_regexp": obj.get("tagRegexp"),
            "extract_cross_reference_formats": obj.get("extractCrossReferenceFormats"),
            "extract_variables": obj.get("extractVariables")
        })
        return _obj

