# coding: utf-8

"""
    Phrase TMS API

    Welcome to Phrase's TMS API documentation.    Please visit our [help center](https://support.phrase.com/hc/en-us/sections/5709662083612) for more information about the APIs.    If you have any questions, please contact [Support](https://support.phrase.com/hc/requests/new).    Please, include the `User-Agent` header with the name of your application or project. It might be a good idea to include some sort of contact information as well, so that we can get in touch if necessary. Examples of excellent `User-Agent` headers:  > User-Agent: Example mobile app (example@phrase.com) <br/> User-Agent: ACME Inc Java 1.8 Client (http://acmeinc.com/contact)  # noqa: E501

    The version of the OpenAPI document: Latest
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class HtmlSettingsDto(BaseModel):
    """
    HtmlSettingsDto
    """
    break_tag_creates_segment: Optional[StrictBool] = Field(None, alias="breakTagCreatesSegment", description="Default: true")
    unknown_tag_creates_tag: Optional[StrictBool] = Field(None, alias="unknownTagCreatesTag", description="Default: true")
    preserve_whitespace: Optional[StrictBool] = Field(None, alias="preserveWhitespace", description="Default: false")
    import_comments: Optional[StrictBool] = Field(None, alias="importComments", description="Default: true")
    exclude_elements: Optional[StrictStr] = Field(None, alias="excludeElements", description="Example: \"script,blockquote\"")
    tag_regexp: Optional[StrictStr] = Field(None, alias="tagRegexp")
    char_entities_to_tags: Optional[StrictStr] = Field(None, alias="charEntitiesToTags")
    translate_meta_tag_regexp: Optional[StrictStr] = Field(None, alias="translateMetaTagRegexp")
    import_default_meta_tags: Optional[StrictBool] = Field(None, alias="importDefaultMetaTags", description="Default: true")
    translatable_attributes: Optional[StrictStr] = Field(None, alias="translatableAttributes")
    import_default_attributes: Optional[StrictBool] = Field(None, alias="importDefaultAttributes", description="Default: true")
    non_translatable_inline_elements: Optional[StrictStr] = Field(None, alias="nonTranslatableInlineElements", description="Example: \"code\"")
    translatable_inline_elements: Optional[StrictStr] = Field(None, alias="translatableInlineElements", description="Example: \"span\"")
    update_lang: Optional[StrictBool] = Field(None, alias="updateLang", description="Default: false")
    escape_disabled: Optional[StrictBool] = Field(None, alias="escapeDisabled", description="Default: `false`")
    __properties = ["breakTagCreatesSegment", "unknownTagCreatesTag", "preserveWhitespace", "importComments", "excludeElements", "tagRegexp", "charEntitiesToTags", "translateMetaTagRegexp", "importDefaultMetaTags", "translatableAttributes", "importDefaultAttributes", "nonTranslatableInlineElements", "translatableInlineElements", "updateLang", "escapeDisabled"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> HtmlSettingsDto:
        """Create an instance of HtmlSettingsDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> HtmlSettingsDto:
        """Create an instance of HtmlSettingsDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return HtmlSettingsDto.parse_obj(obj)

        _obj = HtmlSettingsDto.parse_obj({
            "break_tag_creates_segment": obj.get("breakTagCreatesSegment"),
            "unknown_tag_creates_tag": obj.get("unknownTagCreatesTag"),
            "preserve_whitespace": obj.get("preserveWhitespace"),
            "import_comments": obj.get("importComments"),
            "exclude_elements": obj.get("excludeElements"),
            "tag_regexp": obj.get("tagRegexp"),
            "char_entities_to_tags": obj.get("charEntitiesToTags"),
            "translate_meta_tag_regexp": obj.get("translateMetaTagRegexp"),
            "import_default_meta_tags": obj.get("importDefaultMetaTags"),
            "translatable_attributes": obj.get("translatableAttributes"),
            "import_default_attributes": obj.get("importDefaultAttributes"),
            "non_translatable_inline_elements": obj.get("nonTranslatableInlineElements"),
            "translatable_inline_elements": obj.get("translatableInlineElements"),
            "update_lang": obj.get("updateLang"),
            "escape_disabled": obj.get("escapeDisabled")
        })
        return _obj

